<?php

namespace GPLoker\Inc;

class Job {
	private $job;
	private $validThrough;
	private $position;
	private $employmentType;
	private $company;
	private $company_id;
	private $salary;
	private $salaryUnit;
    private $salaryIsEmpty;
	private $address;
	private $city;
	private $province;
	private $postalCode;
	private $gender;
	private $maxAge;
	private $apply;
    private $isSticky;
    private $salaryLabel;

	public function __construct( $post = null ) {
	    if ( empty($post) ) {
	        global $post;
	    }
		
		$this->job = get_post( $post );    
		$this->company_id = intval($this->meta( 'company' ));
	}

	public static function get( $post ): Job {
		return new self( $post );
	}

	public function data() {
		return $this->job;
	}

	/**
	 * @return mixed
	 */
	public function getId() {
		return $this->job->ID;
	}

	/**
	 * @return mixed
	 */
	public function getDatePosted( $format = 'Y-m-d' ) {
		return date( $format, strtotime( $this->job->post_date ) );
	}

	public function getPosition() {
		if ( empty( $this->position ) ) {
			$this->position = $this->meta( 'position' );
		}

		return $this->position;
	}

    public function isSticky(): bool
    {
        if ( empty($this->isSticky) ) {
            $this->isSticky = $this->meta('gplokerpro_is_sticky') === 'on';
        }

        return $this->isSticky;
    }

	/**
	 * @return mixed
	 */
	public function getValidThrough( $format = 'Y-m-d' ) {
		if ( empty( $this->validThrough ) ) {
			$this->validThrough = $this->meta( 'valid_through' );
			if ( ! empty( $this->validThrough ) ) {
				$this->validThrough = date( $format, strtotime( $this->validThrough ) );
			}
		}

		return $this->validThrough;
	}

	/**
	 * @return mixed
	 */
	public function getEmploymentType( $translation = false ) {
		if ( empty( $this->employmentType ) ) {
			$this->employmentType = $this->meta( 'employment_type' );
		}

		if ( $translation ) {
			$types = JobMenu::employmentTypes();

			return  ! empty($types[$this->employmentType]) ? $types[$this->employmentType] : 'Full Time';
		}

		return $this->employmentType;
	}

	public function getCompanyId() {
		return $this->company_id;
	}

	/**
	 * @return mixed
	 */
	public function getCompany(): Company {
		return Company::get( (int) $this->getCompanyId() );
	}

	public function getCompanyName() {
		return $this->getCompany()->getTitle();
	}

	/**
	 * @return mixed
	 */
	public function getCompanyLogo( $size = 'thumbnail') {
		$company_logo_url = $this->getCompany()->getLogo($size);

		return $company_logo_url;
	}

	/**
	 * @return mixed
	 */
	public function getCompanyPhone() {
		return $this->getCompany()->getPhone();
	}

	/**
	 * @return mixed
	 */
	public function getCompanyEmail() {
		return $this->getCompany()->getEmail();
	}

	/**
	 * @return mixed
	 */
	public function getCompanyWebsite() {
		return $this->getCompany()->getWebsite();
	}

	public function getCompanyLink() {
		return $this->getCompany()->getCompanyLink();
	}

	/**
	 * @return mixed
	 */
	public function getSalary( $raw = true ) {
		if ( empty( $this->salary ) ) {
			$this->salary = $this->meta( 'monetary_amount' );
		}
		
		if ( ! $raw ) {
			$this->salary = GPLokerCurrency( $this->salary );
		}

		return $this->salary ?? 'Negotiable';
	}

	/**
	 * @return mixed
	 */
	public function getSalaryUnit( $raw = true ) {
		if ( empty( $this->salaryUnit ) ) {
			$this->salaryUnit = $this->meta( 'monetary_amount_unit' );
		}
		
		if ( ! $raw ) {
			$salary_translation =[
				'HOUR'  => 'Per Jam',
				'WEEK'  => 'Mingguan',
				'MONTH' => 'Bulanan',
				'YEAR'  => 'Tahunan',
			];
			
			$this->salaryUnit = ! empty( $salary_translation[$this->salaryUnit] ) ? $salary_translation[$this->salaryUnit] : $this->salaryUnit;
		}

		return $this->salaryUnit;
	}
    
    public function salaryIsEmpty()
    {
        if ( empty( $this->salaryIsEmpty ) ) {
            $this->salaryIsEmpty = empty($this->meta( 'monetary_amount' ));
        }
        return $this->salaryIsEmpty;
    }
    
    public function getSalaryLabel()
    {
        if ( empty($this->salaryLabel) ) {
            $this->salaryLabel = $this->meta('salary_label', 'negotiable');
        }
        
        return $this->salaryLabel;
    }

	/**
	 * @return mixed
	 */
	public function getAddress() {
		if ( empty( $this->address ) ) {
			$this->address = $this->meta( 'address' );
		}

		return $this->address;
	}

	/**
	 * @return mixed
	 */
	public function getCity() {
		if ( empty( $this->city ) ) {
			$this->city = $this->meta( 'city' );
		}

		return $this->city;
	}

	/**
	 * @return mixed
	 */
	public function getProvince() {
		if ( empty( $this->province ) ) {
			$this->province = $this->meta( 'province' );
		}

		return $this->province;
	}

	/**
	 * @return mixed
	 */
	public function getPostalCode() {
		if ( empty( $this->postalCode ) ) {
			$this->postalCode = $this->meta( 'postal_code' );
		}

		return $this->postalCode;
	}

	/**
	 * @return mixed
	 */
	public function getGender() {
		if ( empty( $this->gender ) ) {
			$this->gender = $this->meta( 'gender' );
		}

		return $this->gender;
	}

	public function getApplyLinks() {
		if ( empty( $this->apply ) ) {
			$this->apply = $this->meta( 'link_apply' );
		}

		return $this->apply;
	}

	/**
	 * @return mixed
	 */
	public function getMaxAge() {
		if ( empty( $this->maxAge ) ) {
			$this->maxAge = $this->meta( 'max_age' );
		}

		return $this->maxAge;
	}

	public function getLocations( $plain_text = false ) {
		$location = [];
		$terms    = get_the_terms( $this->getId(), 'location' );
		if ( $terms && ! is_wp_error( $terms ) ) {
			if ( ! $plain_text ) {
				foreach ( $terms as $term ) {
					$location[] = sprintf( '<a href="%s">%s</a>', get_term_link( $term ), $term->name );
				}
			} else {
				foreach ( $terms as $term ) {
					$location[] = $term->name;
				}
			}

		}

		return implode( ', ', $location );
	}
	
	public function getTags($tag_name = 'Tags', $separator = ', ') {
	    $terms = get_the_terms( $this->getId(), 'loker-tags' );
	    
	    $tags = [];
	    if ( $terms && ! is_wp_error( $terms ) ) {
	        foreach ( $terms as $term ) {
        		$tags[] = sprintf( '<a href="%s">%s</a>', get_term_link( $term ), $term->name );
        	}
	    }
	    
	    $tags_html = '';
	    if ( $tags ) {
	        $tags_html = '<span>Tags:</span>';
	        $tags_html .= implode($separator, $tags);
	    }
	    
	    return $tags_html;
	}

	public function meta( $name, $default = null ) {
		$meta = get_post_meta( $this->getId(), $name, true );
		if ( ! empty( $meta ) ) {
			return $meta;
		}

		return $default;
	}
}
