<?php

namespace GPLoker\Inc;

use CSF;

class Option
{
    private static $prefix = '_gploker';

    public function __construct()
    {
        add_filter('upload_mimes', [$this, 'allowSVG']);

        $this->fields();
        $this->taxonomy();

    }

    public function allowSVG($upload_mimes)
    {
        if (current_user_can('administrator' && self::get('allow_svg_upload', true))) {
            $upload_mimes['svg']  = 'image/svg+xml';
            $upload_mimes['svgz'] = 'image/svg+xml';
        }

        return $upload_mimes;
    }

    private function fields()
    {
        if (class_exists('CSF')) {

            CSF::createOptions(self::$prefix, [
                'framework_title' => 'GPLoker Pro Options <small>by gploker</small>',
                'menu_title'      => 'GPLoker Options',
                'menu_slug'       => 'gploker-options',
                'footer_text'     => '',
                'footer_credit'   => ''
            ]);

            CSF::createSection(self::$prefix, [
                'title'  => 'Loker Advertisement',
                'fields' => [

                    [
                        'id'       => 'place_ads1',
                        'type'     => 'textarea',
                        'title'    => 'Ads 1',
                        'sanitize' => false,
                        'desc'     => 'Ads Code or Shortcode'
                    ],
                    [
                        'id'       => 'place_ads2',
                        'type'     => 'textarea',
                        'title'    => 'Ads 2',
                        'sanitize' => false,
                        'desc'     => 'Ads Code or Shortcode'
                    ],
                ]
            ]);

            # Popup Apply
            CSF::createSection(self::$prefix, [
                'id'    => 'apply_popup',
                'title' => 'Popup Lamaran Kerja'
            ]);

            CSF::createSection(self::$prefix, [
                'parent' => 'apply_popup',
                'title'  => 'Popup Regular',
                'fields' => [
                    [
                        'id'      => 'popup_regular_title',
                        'type'    => 'text',
                        'title'   => 'Title',
                        'default' => 'Kirim Lamaran'
                    ],
                    [
                        'id'      => 'popup_regular_message',
                        'type'    => 'textarea',
                        'title'   => 'Message',
                        'default' => "Bagi anda yang sudah memenuhi persyaratan silahkan lamar melalui link :\n{{LINK_APPLY}}",
                        'desc'    => 'gunakan varibale ini untuk data dinamis: <code>{{LINK_APPLY}}</code>, <code>{{EXPIRED_DATE}}</code>'
                    ],
                    [
                        'id'      => 'popup_regular_expired_label',
                        'type'    => 'text',
                        'title'   => 'Expired Label',
                        'default' => 'Expired Date :'
                    ],
                ]
            ]);

            CSF::createSection(self::$prefix, [
                'parent' => 'apply_popup',
                'title'  => 'Popup Expired',
                'fields' => [
                    [
                        'id'      => 'popup_expired_title',
                        'type'    => 'text',
                        'title'   => 'Title',
                        'default' => 'Lowongan Ini Sudah Ditutup'
                    ],
                    [
                        'id'      => 'popup_expired_message',
                        'type'    => 'textarea',
                        'title'   => 'Message',
                        'default' => "Lowongan kerja <strong>{{JOB_POSITION}} {{COMPANY_NAME}}</strong> sudah ditutup pada tanggal {{EXPIRED_DATE}}, \nsilahkan kembali ke halaman utama untuk melihat info lowongan kerja terbaru.",
                        'desc'    => 'gunakan variable ini untuk data dinamis: <code>{{JOB_POSITION}}</code>, <code>{{EXPIRED_DATE}}</code>, <code>{{COMPANY_NAME}}</code>'
                    ],
                    [
                        'id'      => 'popup_regular_readon_label',
                        'type'    => 'text',
                        'title'   => 'Read On Label',
                        'default' => 'Lihat Lowongan Lainnya'
                    ],
                ]
            ]);

            CSF::createSection(self::$prefix, [
                'title'  => 'Notes Lamaran',
                'fields' => [

                    [
                        'id'    => 'show_notes',
                        'type'  => 'switcher',
                        'title' => 'Show Notes',
                    ],
                    [
                        'id'            => 'notes',
                        'type'          => 'wp_editor',
                        'title'         => 'Notes',
                        'media_buttons' => false,
                        'desc'          => 'catatan yang muncul dihalaman detail loker. Gunakan variable ini untuk data dinamis: <code>{{JOB_POSITION}}</code>, <code>{{COMPANY_NAME}}</code> dan <code>{{EXPIRED_DATE}}</code>'
                    ],
                ]
            ]);

            # utility section
            CSF::createSection(self::$prefix, [
                'id'    => 'utitlites',
                'title' => 'Utility',
            ]);

            CSF::createSection(self::$prefix, [
                'parent' => 'utitlites',
                'title'  => 'Search Form',
                'fields' => [
                    [
                        'id'    => 'enable_extra_search_filter',
                        'type'  => 'switcher',
                        'title' => 'Enable Extra Search Filter',
                    ],
                    [
                        'id'          => 'extra_search_filters',
                        'type'        => 'select',
                        'title'       => 'Extra Search Filters',
                        'subtitle'    => 'Maximum 3 Tags',
                        'placeholder' => 'Select a tags',
                        'chosen'      => true,
                        'multiple'    => true,
                        'dependency'  => ['enable_extra_search_filter', '==', 'true'],
                        'settings'  => [
                            'max_selected_options' => 3
                        ],
                        'options'     => 'tags',
                        'query_args'  => [
                            'taxonomy' => 'loker-tags',
                        ],
                    ],

                ]
            ]);

            CSF::createSection(self::$prefix, [
                'parent' => 'utitlites',
                'title'  => 'Utility',
                'fields' => [
                    [
                        'id'    => 'disable_gutenberg',
                        'type'  => 'switcher',
                        'title' => 'Disable Gutenberg',
                    ],
                    [
                        'id'      => 'allow_svg_upload',
                        'type'    => 'switcher',
                        'title'   => 'Enable SVG Upload',
                        'default' => true
                    ],
                    [
                        'id'      => 'category_image_upload',
                        'type'    => 'switcher',
                        'title'   => 'Enable Category Upload',
                        'default' => true
                    ],
                    [
                        'id'      => 'use_auto_page_break',
                        'type'    => 'switcher',
                        'title'   => 'Enable Auto Page Break',
                        'default' => false
                    ],
                    [
                        'id'         => 'page_break_at_paragraph',
                        'type'       => 'number',
                        'title'      => 'Break Pada Paragraf Ke',
                        'default'    => 3,
                        'dependency' => ['use_auto_page_break', '==', 'true'],
                    ],
                    [
                        'id'         => 'page_break_name',
                        'type'       => 'text',
                        'title'      => 'Page Label',
                        'default'    => 'Halaman',
                        'dependency' => ['use_auto_page_break', '==', 'true'],
                    ],
                    [
                        'id'         => 'page_break_show_all',
                        'type'       => 'text',
                        'title'      => 'Page Show All Label',
                        'default'    => 'Lihat Semua',
                        'dependency' => ['use_auto_page_break', '==', 'true'],
                    ],
                    [
                        'id'      => 'show_status',
                        'type'    => 'switcher',
                        'title'   => 'Show Status',
                        'default' => true
                    ],
                    [
                        'id'      => 'job_archive_page_title',
                        'type'    => 'text',
                        'title'   => 'Show Status',
                        'default' => 'Lowongan Kerja Terbaru {{YEAR}}',
                        'desc'    => 'Available shortcode: <code>{{DATE}}</code>, <code>{{DAY_NAME}}</code>, <code>{{MONTH}}</code>, <code>{{MONTH_NAME}}</code>, <code>{{MONTH_NAME_SHORT}}</code>, <code>{{YEAR}}</code>'
                    ]

                ]
            ]);

        }
    }

    private function taxonomy()
    {

        if (class_exists('CSF') && self::get('category_image_upload', true)) {

            $prefix = '_gploker_category';

            CSF::createTaxonomyOptions($prefix, [
                'taxonomy'  => 'loker-category',
                'data_type' => 'unserialize',
            ]);

            CSF::createSection($prefix, [
                'fields' => [

                    [
                        'id'      => 'icon',
                        'type'    => 'media',
                        'title'   => 'Icon',
                        'library' => 'image',
                    ],

                ]
            ]);

        }

    }

    public static function get($name, $default = null)
    {
        $options = get_option(self::$prefix);

        return (isset($options[$name])) ? $options[$name] : $default;
    }
}

new Option();
