<?php
/**
 * The template for displaying search forms in Generate
 *
 * @package GeneratePress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$url = esc_url( home_url( '/' ) );
$page_for_posts = get_option('page_for_posts', null);
if ( $page_for_posts) {
	$url = get_permalink($page_for_posts);
}
?>
<form method="get" class="search-form" action="<?php echo $url ; ?>">
	<label>
		<span class="screen-reader-text"><?php echo apply_filters( 'generate_search_label', _x( 'Search for:', 'label', 'generatepress' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></span>
		<input type="search" class="search-field" placeholder="<?php echo esc_attr( apply_filters( 'generate_search_placeholder', _x( 'Search &hellip;', 'placeholder', 'generatepress' ) ) ); ?>" value="<?php echo esc_attr( get_search_query() ); ?>" name="s" title="<?php echo esc_attr( apply_filters( 'generate_search_label', _x( 'Search for:', 'label', 'generatepress' ) ) ); ?>">
	</label>
	<?php
	printf(
			'<input type="submit" class="blog-search-submit" value="%s">',
			apply_filters( 'generate_search_button', _x( 'Search', 'submit button', 'generatepress' ) ) // phpcs:ignore -- Escaping not necessary here.
		);
	?>
</form>