<?php
/**
 * The template for displaying single posts.
 *
 * @package GeneratePress
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
$job = GPLokerGetCurrentJob();
$job_expired   = strtotime( $job->getValidThrough('Y-m-d 23:59:59') ) < current_time('timestamp') ;
$is_negotiable = $job->salaryIsEmpty();
$isSticky = $job->isSticky() ? 'is-sticky-job' : '';
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( $isSticky ? 'is-sticky-job' : '' ); ?> <?php generate_do_microdata( 'article' ); ?>>
	<div class="inside-article">
		<?php
		/**
		 * generate_before_content hook.
		 *
		 * @since 0.1
		 *
		 * @hooked generate_featured_page_header_inside_single - 10
		 */
		do_action( 'generate_before_content' );

		if ( generate_show_entry_header() ) :
			?>
			<header <?php generate_do_attr( 'entry-header' ); ?>>
				<?php
				/**
				 * generate_before_entry_title hook.
				 *
				 * @since 0.1
				 */
				do_action( 'generate_before_entry_title' );

				?>

				<div class="company-wrap single-job">
					<div class="company-logo"><?php echo sprintf(
						'<img src="%s" alt="Logo %s"/>',
							$job->getCompanyLogo(),
							$job->getCompanyName()
						);?>
					</div>
					<div class="company-job-title">
						<?php if ( generate_show_title() ) {
							$params = generate_get_the_title_parameters();
							the_title( $params['before'], $params['after'] );
						}; ?>
						<div class="work-location">
							<h2 class="company-title"><?php echo $job->getCompanyLink();?></h2>
							<?php if ( ! $is_negotiable ): ?>
							<div class="psg"><?php echo $job->getLocations();?></div>
							<?php endif;?>
						</div>
		
						<?php if ( GPLokerOption('show_status', false) ) : ?>
                    <div class="loker_timer">
                        <?php if (! $job_expired ) : ?>
                            <span class="clk"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-alarm" viewBox="0 0 16 16">
  <path d="M8.5 5.5a.5.5 0 0 0-1 0v3.362l-1.429 2.38a.5.5 0 1 0 .858.515l1.5-2.5A.5.5 0 0 0 8.5 9V5.5z"/>
  <path d="M6.5 0a.5.5 0 0 0 0 1H7v1.07a7.001 7.001 0 0 0-3.273 12.474l-.602.602a.5.5 0 0 0 .707.708l.746-.746A6.97 6.97 0 0 0 8 16a6.97 6.97 0 0 0 3.422-.892l.746.746a.5.5 0 0 0 .707-.708l-.601-.602A7.001 7.001 0 0 0 9 2.07V1h.5a.5.5 0 0 0 0-1h-3zm1.038 3.018a6.093 6.093 0 0 1 .924 0 6 6 0 1 1-.924 0zM0 3.5c0 .753.333 1.429.86 1.887A8.035 8.035 0 0 1 4.387 1.86 2.5 2.5 0 0 0 0 3.5zM13.5 1c-.753 0-1.429.333-1.887.86a8.035 8.035 0 0 1 3.527 3.527A2.5 2.5 0 0 0 13.5 1z"/>
</svg> <?php echo GPLokerTimeAgo();?></span>
                        <?php else : ?>
                            <span class="cls"><b>Ditutup</b></span>
                        <?php endif;?>
                    </div>
                    <?php endif;?>
		
					</div>
					<div class="gploker-job-salary">
						<div class="salary"><span><?php echo $is_negotiable ? $job->getSalaryLabel() : $job->getSalary( false );?></span></div>
						<div class="job-status"><?php echo $job->getSalaryUnit( false );?></div>
					</div>
                    
				</div>
			</header>
			<?php if ( $ads1 = GPLokerGetAds1() ) : ?>
			<div class="ads_jobs_btm"><?php echo $ads1;?></div>
			<?php endif;?>
			
		<?php
		endif;

		/**
		 * generate_after_entry_header hook.
		 *
		 * @since 0.1
		 *
		 * @hooked generate_post_image - 10
		 */
		do_action( 'generate_after_entry_header' );

		$itemprop = '';

		if ( 'microdata' === generate_get_schema_type() ) {
			$itemprop = ' itemprop="text"';
		}
		?>

		<div class="entry-content"<?php echo $itemprop; // phpcs:ignore -- No escaping needed. ?>>
			<?php
			the_content();

			wp_link_pages(
				array(
					'before' => '<div class="page-links">' . __( 'Pages:', 'generatepress' ),
					'after'  => '</div>',
				)
			);
			?>
		</div>
		<?php GPLokerNotes();?>
		<div class="popup-apply">
			<button class="apply-loker" id="apply-loker">Lamar Sekarang</button>
		</div>
		<div class="gploker-tags">
		    <?php echo $job->getTags();?>
		</div>
		<div class="share_loker">
		    <div class="share_button">
		    <?php echo do_shortcode( '[addtoany]' ); ?>
		    </div>
		    
		    <?php
	        $bookmark = \GPLoker\Inc\Bookmark::get();
	        
	        $hasBookmark = is_array($bookmark) && in_array(get_the_ID(), $bookmark) ? ' has-bookmark' : '';?>
	        
		    <div class="bmark<?php echo $hasBookmark;?>">
		       
		        <div class="on_save gploker-bookmark" data-id="<?php the_ID();?>">
                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bookmark-check-fill" viewBox="0 0 16 16">
                      <path fill-rule="evenodd" d="M2 15.5V2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v13.5a.5.5 0 0 1-.74.439L8 13.069l-5.26 2.87A.5.5 0 0 1 2 15.5m8.854-9.646a.5.5 0 0 0-.708-.708L7.5 7.793 6.354 6.646a.5.5 0 1 0-.708.708l1.5 1.5a.5.5 0 0 0 .708 0z"/>
                    </svg>
                </div>
                
                <div class="no_save gploker-bookmark" data-id="<?php the_ID();?>"><svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-bookmark" viewBox="0 0 16 16">
                  <path d="M2 2a2 2 0 0 1 2-2h8a2 2 0 0 1 2 2v13.5a.5.5 0 0 1-.777.416L8 13.101l-5.223 2.815A.5.5 0 0 1 2 15.5zm2-1a1 1 0 0 0-1 1v12.566l4.723-2.482a.5.5 0 0 1 .554 0L13 14.566V2a1 1 0 0 0-1-1z"/></svg>
                </div>
                
		    </div>
		</div>
        <?php if ( $ads2 = GPLokerGetAds2() ) : ?>
        <div class="ads_jobs_ins"><?php echo $ads2;?></div>
        <?php endif;?>

		<div class="related_post">
		<?php
		/**
		 * generate_after_entry_content hook.
		 *
		 * @since 0.1
		 *
		 * @hooked generate_footer_meta - 10
		 */
		do_action( 'generate_after_entry_content' );

		/**
		 * generate_after_content hook.
		 *
		 * @since 0.1
		 */
		do_action( 'generate_after_content' );
		?>
		</div>
	</div>
</article>
