<?php
defined('ABSPATH') or die();

$keyword  = ! empty($_GET['s']) ? sanitize_text_field($_GET['s']) : '';
$location = ! empty($_GET['location']) ? sanitize_text_field($_GET['location']) : '';
$category = ! empty($_GET['category']) ? sanitize_text_field($_GET['category']) : '';

$xfIsEnabled = GPLokerOption('enable_extra_search_filter', false);
$xfSelected  = ! empty($_GET['xf']) ? wp_slash($_GET['xf']) : [];
$xfLists     = GPLokerOption('extra_search_filters', []);

$xfNameLists = "";
if ( is_array($xfLists) && $xfLists !== [] ) {
    foreach ($xfLists as $list) {
        
        $term = get_term_by( 'id', intval($list), 'loker-tags' );
        if ( $term ) {
            $xfNameLists .= sprintf('<label for="xf-%s" class="ck_con">%s<input type="checkbox" name="xf[]" id="xf-%s" value="%s" %s><span class="ck_con_mark"></span></label>',
                $list,
                $term->name,
                $list,
                $term->slug,
                in_array($term->slug, $xfSelected) ? 'checked' : ''
            );
        }
    }
}
?>

<div class="gploker-search-wrapp">
	<form action="<?php echo home_url();?>">
		<div class="gploker-search-form-wrap">
		<div class="keywords">
			<input type="text" name="s" value="<?php echo $keyword;?>" placeholder="Cari Loker..."/>
		</div>
		<div class="location">
			<?php GPLokerSelectLocation($location); ?>
		</div>
		<div class="category">
			<?php GPLokerSelectCategories($category);?>
		</div>


		<div class="button-search">
			<button>Cari</button>
		</div>
		</div>
        <?php
        if ( !empty($xfNameLists) && $xfIsEnabled ) : ?>
            <div class="extra-filter">
                <?php echo $xfNameLists;?>
            </div>
        <?php endif;?>
	</form>
</div>
