<?php
/**
 * Defines customizer options
 *
 * @package Lokerpro
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'lokerpro_get_home' ) ) {
	/**
	 * Get homepage without http/https and www
	 *
	 * @since 1.0.0
	 * @return string
	 */
	function lokerpro_get_home() {
		$protocols = array( 'http://', 'https://', 'http://www.', 'https://www.', 'www.' );
		return str_replace( $protocols, '', home_url() );
	}
}

/**
 * Option array customizer library
 *
 * @since 1.0.0
 */
function pjs_library_options_customizer() {

	// Prefix_option.
	$pjsprefix = 'pjs';

	/*
	 * Theme defaults
	 *
	 * @since v.1.0.0
	 */
	// General.
	$color_scheme = '#124187';
	$theme_color = '#009BA9';
	$color_link       = '#124187';
	$color_link_hover = '#FCBB23';

	// Header.
	$header_bgcolor  = '#ffffff';
	$sitetitle_color = '#124187';
	$sitedesc_color  = '#555555';

	// Top menu.
	$menu_bgcolor      = '#ffffff';
	$menu_color        = '#292d33';
	$menu_hoverbgcolor = '#f1f2f3';
	$menu_hovercolor   = '#FCBB23';

	$default_logo = get_template_directory_uri() . '/images/logo.png';

	// content.
	$content_bgcolor = '#ffffff';
	$content_color   = '#000000';
	$prlbackg		 = '#222';
	$prlbackgbox	 = '#038383';
	$ontopcolor	 	 = '#000';


	// Footer.
	$copyright_bgcolor        = '#124187';
	$copyright_fontcolor      = '#efefef';
	$copyright_linkcolor      = '#ffffff';
	$copyright_hoverlinkcolor = '#bdc3c7';

	// Typhography.
	$body_size                = '14';
	$opsi_heading_font        = 'Open Sans';
	$opsi_body_font           = 'Open Sans';
	$opsi_heading_font_weight = '700';
	$opsi_body_font_weight    = '500';

	// Add Lcs.
	$hm         = md5( lokerpro_get_home() );
	$license    = trim( get_option( 'lokerpro_core_license_key' . $hm ) );
	$upload_dir = wp_upload_dir();

	// Stores all the controls that will be added.
	$options = array();

	// Stores all the sections to be added.
	$sections = array();

	// Stores all the panels to be added.
	$panels = array();

	// Adds the sections to the $options array.
	$options['sections'] = $sections;

	/*
	 * General Section Options
	 *
	 * @since v.1.0.0
	 */
	$panel_general = 'panel-general';
	$panels[]      = array(
		'id'       => $panel_general,
		'title'    => __( 'General', 'lokerpro' ),
		'priority' => '30',
	);

	$section    = 'layout_options';
	$sections[] = array(
		'id'       => $section,
		'title'    => __( 'General Layout', 'lokerpro' ),
		'priority' => 35,
		'panel'    => $panel_general,
	);

	$options[ $pjsprefix . '_texttitlehomepage' ] = array(
		'id'          => $pjsprefix . '_texttitlehomepage',
		'label'       => __( 'Text Home Page.', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'text',
		'description' => __( 'Allow you add text before list software in homepage. Default is "Latest Update".', 'lokerpro' ),
	);

	// Colors.
	$section    = 'colors';
	$sections[] = array(
		'id'       => $section,
		'title'    => __( 'General Colors', 'lokerpro' ),
		'panel'    => $panel_general,
		'priority' => 40,
	);

	$options[ $pjsprefix . '_theme-color' ] = array(
		'id'      => $pjsprefix . '_theme-color',
		'label'   => __( 'Theme Color', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $theme_color,
	);


	$options[ $pjsprefix . '_scheme-color' ] = array(
		'id'      => $pjsprefix . '_scheme-color',
		'label'   => __( 'Base Color Scheme', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $color_scheme,
	);

	$options[ $pjsprefix . '_link-color' ] = array(
		'id'      => $pjsprefix . '_link-color',
		'label'   => __( 'Link Color', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $color_link,
	);

	$options[ $pjsprefix . '_hover-link-color' ] = array(
		'id'      => $pjsprefix . '_hover-link-color',
		'label'   => __( 'Hover Link Color', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $color_link_hover,
	);

	$options[ $pjsprefix . '_content-color' ] = array(
		'id'       => $pjsprefix . '_content-color',
		'label'    => __( 'Font Color - Body', 'lokerpro' ),
		'section'  => $section,
		'type'     => 'color',
		'default'  => $content_color,
		'priority' => 40,
	);

	$options[ $pjsprefix . '_prlbackg' ] = array(
		'id'       => $pjsprefix . '_prlbackg',
		'label'    => __( 'Parallax Ads Background', 'lokerpro' ),
		'section'  => $section,
		'type'     => 'color',
		'default'  => $prlbackg,
		'priority' => 40,
	);

	$options[ $pjsprefix . '_prlbackgbox' ] = array(
		'id'       => $pjsprefix . '_prlbackgbox',
		'label'    => __( 'Parallax Ads Box Color', 'lokerpro' ),
		'section'  => $section,
		'type'     => 'color',
		'default'  => $prlbackgbox,
		'priority' => 40,
	);

	$options[ $pjsprefix . '_ontopcolor' ] = array(
		'id'       => $pjsprefix . '_ontopcolor',
		'label'    => __( 'On top Button Color', 'lokerpro' ),
		'section'  => $section,
		'type'     => 'color',
		'default'  => $ontopcolor,
		'priority' => 40,
	);

	// Colors.
	$section    = 'background_image';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Background Image', 'lokerpro' ),
		'panel'       => $panel_general,
		'description' => __( 'Background Image only display, if using box layout.', 'lokerpro' ),
		'priority'    => 45,
	);

	// Typography.
	$section      = 'typography';
	$font_choices = customizer_library_get_font_choices();
	$sections[]   = array(
		'id'       => $section,
		'title'    => __( 'Typography', 'lokerpro' ),
		'panel'    => $panel_general,
		'priority' => 50,
	);

	$options[ $pjsprefix . '_primary-font' ] = array(
		'id'      => $pjsprefix . '_primary-font',
		'label'   => __( 'Heading Font', 'lokerpro' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $font_choices,
		'default' => $opsi_heading_font,
	);

	$options[ $pjsprefix . '_secondary-font' ] = array(
		'id'      => $pjsprefix . '_secondary-font',
		'label'   => __( 'Body Font', 'lokerpro' ),
		'section' => $section,
		'type'    => 'select',
		'choices' => $font_choices,
		'default' => $opsi_body_font,
	);

	$primaryweight = array(
		'300' => '300',
		'400' => '400',
		'500' => '500',
		'600' => '600',
		'700' => '700',
	);

	$options[ $pjsprefix . '_body_size' ] = array(
		'id'          => $pjsprefix . '_body_size',
		'label'       => __( 'Body font size', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'number',
		'default'     => $body_size,
		'input_attrs' => array(
			'min'  => 12,
			'max'  => 50,
			'step' => 1,
		),
	);

	$options[ $pjsprefix . '_primary-font-weight' ] = array(
		'id'          => $pjsprefix . '_primary-font-weight',
		'label'       => __( 'Heading font weight', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'select',
		'choices'     => $primaryweight,
		'description' => __( 'Note: some font maybe not display properly, if not display properly try to change this font weight.', 'lokerpro' ),
		'default'     => $opsi_heading_font_weight,
	);

	$options[ $pjsprefix . '_secondary-font-weight' ] = array(
		'id'          => $pjsprefix . '_secondary-font-weight',
		'label'       => __( 'Body font weight', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'select',
		'choices'     => $primaryweight,
		'description' => __( 'Note: some font maybe not display properly, if not display properly try to change this font weight.', 'lokerpro' ),
		'default'     => $opsi_body_font_weight,
	);

	/*
	 * Header Section Options
	 *
	 * @since v.1.0.0
	 */
	$panel_header = 'panel-header';
	$panels[]     = array(
		'id'       => $panel_header,
		'title'    => __( 'Header', 'lokerpro' ),
		'priority' => '40',
	);

	// Logo.
	$section    = 'title_tagline';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Site Identity', 'lokerpro' ),
		'priority'    => 30,
		'panel'       => $panel_header,
		'description' => __( 'Allow you to add icon, logo, change site-title and tagline to your website.', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_logoimage' ] = array(
		'id'          => $pjsprefix . '_logoimage',
		'label'       => __( 'Logo', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'image',
		'default'     => $default_logo,
		'description' => __( 'If using logo, Site Title and Tagline automatic disappear.', 'lokerpro' ),
	);

	$section    = 'header_image';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Header Image', 'lokerpro' ),
		'priority'    => 40,
		'panel'       => $panel_header,
		'description' => __( 'Allow you customize header sections in home page.', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_active-headerimage' ] = array(
		'id'          => $pjsprefix . '_active-headerimage',
		'label'       => __( 'Disable header image', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'checkbox',
		'default'     => 0,
		'priority'    => 25,
		'description' => __( 'If you disable header image, header section will replace with header color.', 'lokerpro' ),
	);

	$bgsize = array(
		'auto'    => 'Auto',
		'cover'   => 'Cover',
		'contain' => 'Contain',
		'initial' => 'Initial',
		'inherit' => 'Inherit',
	);

	$options[ $pjsprefix . '_headerimage_bgsize' ] = array(
		'id'          => $pjsprefix . '_headerimage_bgsize',
		'label'       => __( 'Background Size', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'select',
		'choices'     => $bgsize,
		'priority'    => 30,
		'description' => __( 'The background-size property specifies the size of the header images.', 'lokerpro' ) . ' <a href="' . esc_url( __( 'http://www.w3schools.com/cssref/css3_pr_background-size.asp', 'lokerpro' ) ) . '" target="_blank" rel="nofollow">' . __( 'Learn more!', 'lokerpro' ) . '</a>',
		'default'     => 'auto',
	);

	$bgrepeat = array(
		'repeat'   => 'Repeat',
		'repeat-x' => 'Repeat X',
		'repeat-y' => 'Repeat Y',
		'initial'  => 'Initial',
		'inherit'  => 'Inherit',
	);

	$options[ $pjsprefix . '_headerimage_bgrepeat' ] = array(
		'id'          => $pjsprefix . '_headerimage_bgrepeat',
		'label'       => __( 'Background Repeat', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'select',
		'choices'     => $bgrepeat,
		'priority'    => 35,
		'description' => __( 'The background-repeat property sets if/how a header image will be repeated.', 'lokerpro' ) . ' <a href="' . esc_url( __( 'http://www.w3schools.com/cssref/pr_background-repeat.asp', 'lokerpro' ) ) . '" target="_blank" rel="nofollow">' . __( 'Learn more!', 'lokerpro' ) . '</a>',
		'default'     => 'repeat',
	);

	$bgposition = array(
		'left top'      => 'left top',
		'left center'   => 'left center',
		'left bottom'   => 'left bottom',
		'right top'     => 'right top',
		'right center'  => 'right center',
		'right bottom'  => 'right bottom',
		'center top'    => 'center top',
		'center center' => 'center center',
		'center bottom' => 'center bottom',
	);

	$options[ $pjsprefix . '_headerimage_bgposition' ] = array(
		'id'          => $pjsprefix . '_headerimage_bgposition',
		'label'       => __( 'Background Position', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'select',
		'choices'     => $bgposition,
		'priority'    => 40,
		'description' => __( 'The background-position property sets the starting position of a header image.', 'lokerpro' ) . ' <a href="' . esc_url( __( 'http://www.w3schools.com/cssref/pr_background-position.asp', 'lokerpro' ) ) . '" target="_blank" rel="nofollow">' . __( 'Learn more!', 'lokerpro' ) . '</a>',
		'default'     => 'center top',
	);

	$bgattachment = array(
		'scroll'  => 'Scroll',
		'fixed'   => 'Fixed',
		'local'   => 'Local',
		'initial' => 'Initial',
		'inherit' => 'Inherit',
	);

	$options[ $pjsprefix . '_headerimage_bgattachment' ] = array(
		'id'          => $pjsprefix . '_headerimage_bgattachment',
		'label'       => __( 'Background Attachment', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'select',
		'choices'     => $bgattachment,
		'priority'    => 45,
		'description' => __( 'The background-attachment property sets whether a header image is fixed or scrolls with the rest of the page.', 'lokerpro' ) . ' <a href="' . esc_url( __( 'http://www.w3schools.com/cssref/pr_background-attachment.asp', 'lokerpro' ) ) . '" target="_blank" rel="nofollow">' . __( 'Learn more!', 'lokerpro' ) . '</a>',
		'default'     => 'scroll',
	);

	$section    = 'header_color';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Header Color', 'lokerpro' ),
		'priority'    => 40,
		'panel'       => $panel_header,
		'description' => __( 'Allow you customize header color style.', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_header-bgcolor' ] = array(
		'id'      => $pjsprefix . '_header-bgcolor',
		'label'   => __( 'Background Color - Header', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $header_bgcolor,
	);

	$options[ $pjsprefix . '_sitetitle-color' ] = array(
		'id'      => $pjsprefix . '_sitetitle-color',
		'label'   => __( 'Site title color', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $sitetitle_color,
	);

	$options[ $pjsprefix . '_sitedesc-color' ] = array(
		'id'      => $pjsprefix . '_sitedesc-color',
		'label'   => __( 'Site description color', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $sitedesc_color,
	);

	$options[ $pjsprefix . '_mainmenu-bgcolor' ] = array(
		'id'      => $pjsprefix . '_mainmenu-bgcolor',
		'label'   => __( 'Background Menu', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $menu_bgcolor,
	);

	$options[ $pjsprefix . '_mainmenu-hoverbgcolor' ] = array(
		'id'      => $pjsprefix . '_mainmenu-hoverbgcolor',
		'label'   => __( 'Background Menu Hover and Active', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $menu_hoverbgcolor,
	);

	$options[ $pjsprefix . '_mainmenu-color' ] = array(
		'id'      => $pjsprefix . '_mainmenu-color',
		'label'   => __( 'Text color - Menu', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $menu_color,
	);

	$options[ $pjsprefix . '_hovermenu-color' ] = array(
		'id'      => $pjsprefix . '_hovermenu-color',
		'label'   => __( 'Text hover color - Menu', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $menu_hovercolor,
	);

	$section    = 'menu_style';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Menu Style', 'lokerpro' ),
		'priority'    => 40,
		'panel'       => $panel_header,
		'description' => __( 'Allow you customize menu style.', 'lokerpro' ),
	);

	$sticky = array(
		'sticky'   => __( 'Sticky', 'lokerpro' ),
		'nosticky' => __( 'Static', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_sticky_menu' ] = array(
		'id'      => $pjsprefix . '_sticky_menu',
		'label'   => __( 'Sticky Menu', 'lokerpro' ),
		'section' => $section,
		'type'    => 'radio',
		'choices' => $sticky,
		'default' => 'sticky',
	);

	$section    = 'mobile_header_style';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Mobile Header Style', 'lokerpro' ),
		'priority'    => 40,
		'panel'       => $panel_header,
		'description' => __( 'Allow you customize mobile header style.', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_sticky_moble_header' ] = array(
		'id'      => $pjsprefix . '_sticky_moble_header',
		'label'   => __( 'Sticky Mobile Header', 'lokerpro' ),
		'section' => $section,
		'type'    => 'radio',
		'choices' => $sticky,
		'default' => 'sticky',
	);
	/**
	 * Module
	 */
	$panel_homepage = 'panel-homepage';
	$panels[]       = array(
		'id'       => $panel_homepage,
		'title'    => __( 'Homepage', 'lokerpro' ),
		'priority' => '45',
	);



				$section    = 'notification';
				$sections[] = array(
					'id'          => $section,
					'title'       => __( 'Top Notification', 'lokerpro' ),
					'priority'    => 50,
					'panel'       => $panel_homepage,
					'description' => __( 'Insert your text notification after menu.', 'lokerpro' ),
				);

				$marquee = array(
					'disable'    => __( 'Disable', 'lokerpro' ),
					'textnotif'  => __( 'Text notification', 'lokerpro' ),
					'recentpost' => __( '5 Recent Posts By Category', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_notif_marquee' ] = array(
					'id'      => $pjsprefix . '_notif_marquee',
					'label'   => __( 'Notification', 'lokerpro' ),
					'section' => $section,
					'type'    => 'radio',
					'choices' => $marquee,
					'default' => 'recentpost',
				);
				
				$options[ $pjsprefix . '_textmarquee' ]          = array(
					'id'          => $pjsprefix . '_textmarquee',
					'label'       => __( 'Marquee Text', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'text',
					'description' => __( 'Add text marquee. Default: Recommendation.', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_textnotif' ] = array(
					'id'          => $pjsprefix . '_textnotif',
					'label'       => __( 'HTML or text code.', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'textareajsallowed',
					'priority'    => 60,
					'description' => __( 'Please insert your text for notification here, this will marquee your text after menu', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_category-marque' ] = array(
					'id'       => $pjsprefix . '_category-marque',
					'label'    => __( 'Insert Category If Using Recent Posts', 'lokerpro' ),
					'section'  => $section,
					'type'     => 'category-select',
					'priority' => 70,
					'default'  => '',
				);



	/*
	 * Software Section Options
	 *
	 * @since v.1.0.0
	 */

	$panel_blog = 'panel-blog';
	$panels[]   = array(
		'id'       => $panel_blog,
		'title'    => __( 'Post Page', 'lokerpro' ),
		'priority' => '50',
	);
	
	$section    = 'bloglayout';
	$sections[] = array(
		'id'       => $section,
		'title'    => __( 'Post Page Layout', 'lokerpro' ),
		'priority' => 50,
		'panel'    => $panel_blog,
	);

	$options[ $pjsprefix . '_active-no-more-text' ] = array(
		'id'      => $pjsprefix . '_active-no-more-text',
		'label'   => __( 'Hide No More Posts Available Text', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$blogpagination = array(
		'pjs-pagination' => __( 'Number Pagination', 'lokerpro' ),
		'pjs-infinite'   => __( 'Infinite Scroll', 'lokerpro' ),
		'pjs-more'       => __( 'Button Click', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_blog_pagination' ] = array(
		'id'      => $pjsprefix . '_blog_pagination',
		'label'   => __( 'Blog Navigation Type', 'lokerpro' ),
		'section' => $section,
		'type'    => 'radio',
		'choices' => $blogpagination,
		'default' => 'pjs-more',
	);

	$section    = 'blogcontent';
	$sections[] = array(
		'id'       => $section,
		'title'    => __( 'Post Page Content', 'lokerpro' ),
		'priority' => 50,
		'panel'    => $panel_blog,
	);

	$options[ $pjsprefix . '_active-singlethumb' ] = array(
		'id'      => $pjsprefix . '_active-singlethumb',
		'label'   => __( 'Disable Single Thumbnail', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-socialshare' ] = array(
		'id'      => $pjsprefix . '_active-socialshare',
		'label'   => __( 'Disable Social Share in single', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-breadcrumb' ] = array(
		'id'      => $pjsprefix . '_active-breadcrumb',
		'label'   => __( 'Disable Breadcrumbs', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-relpost' ] = array(
		'id'      => $pjsprefix . '_active-relpost',
		'label'   => __( 'Disable Related Posts in single', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-topapply' ] = array(
		'id'      => $pjsprefix . '_active-topapply',
		'label'   => __( 'Disable Top Apply Button in single', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-botapply' ] = array(
		'id'      => $pjsprefix . '_active-botapply',
		'label'   => __( 'Disable Bottom Apply Button in single', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_relpost_number' ] = array(
		'id'          => $pjsprefix . '_relpost_number',
		'label'       => __( 'Number Related Posts', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'number',
		'default'     => '6',
		'description' => __( 'How much number post want to display on related post.', 'lokerpro' ),
		'input_attrs' => array(
			'min'  => 2,
			'max'  => 12,
			'step' => 2,
		),
	);


	$taxonomy = array(
		'pjs-tags'     => __( 'By Tags', 'lokerpro' ),
		'pjs-category' => __( 'By Categories', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_relpost_taxonomy' ] = array(
		'id'      => $pjsprefix . '_relpost_taxonomy',
		'label'   => __( 'Related Posts Taxonomy', 'lokerpro' ),
		'section' => $section,
		'type'    => 'radio',
		'choices' => $taxonomy,
		'default' => 'pjs-category',
	);

	$comments = array(
		'default-comment' => __( 'Default Comment', 'lokerpro' ),
		'fb-comment'      => __( 'Facebook Comment', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_comment' ] = array(
		'id'      => $pjsprefix . '_comment',
		'label'   => __( 'Single Comment', 'lokerpro' ),
		'section' => $section,
		'type'    => 'radio',
		'choices' => $comments,
		'default' => 'default-comment',
	);

	$options[ $pjsprefix . '_fbappid' ] = array(
		'id'          => $pjsprefix . '_fbappid',
		'label'       => __( 'Facebook App ID', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'text',
		'description' => __( 'If you using fb comment, you must insert your own Facebook App ID, if you not insert this options, so you will using Facebook App ID from us.', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_excerpt_number' ] = array(
		'id'          => $pjsprefix . '_excerpt_number',
		'label'       => __( 'Excerpt length', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'number',
		'default'     => '20',
		'description' => __( 'If you choose excerpt, you can change excerpt lenght (default is 20).', 'lokerpro' ),
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 100,
			'step' => 1,
		),
	);

	$options[ $pjsprefix . '_read_more' ] = array(
		'id'          => $pjsprefix . '_read_more',
		'label'       => __( 'Read more text', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'text',
		'description' => __( 'Add some text here to replace the default [...]. It will automatically be linked to your article.', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_text_register' ] = array(
		'id'          => $pjsprefix . '_text_register',
		'label'       => __( 'Registration text', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'text',
		'description' => __( 'Add some text here to replace the default \'Please register online:\' text before Apply button', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_infojob' ] = array(
		'id'          => $pjsprefix . '_infojob',
		'label'       => __( 'Additional job vacancy information', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'textarea',
		'description' => __( 'Add additional job vacancy information. This will be added at the end of the job posting', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_postrelated' ] = array(
		'id'          => $pjsprefix . '_postrelated',
		'label'       => __( 'Enable Related Posts (Based on the same Category)', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'text',
		'description' => __( 'Enter the position of the related post you want to display. Example: <b style="color: red">1, 2, 3</b>. Then related posts will be displayed after paragraphs 1, 2 and 3.', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_postrelatedbytag' ] = array(
		'id'          => $pjsprefix . '_postrelatedbytag',
		'label'       => __( 'Enable Related Posts (Based on the same Tag) 2nd', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'text',
		'description' => __( 'Enter the position of the related post you want to display. Example: <b style="color: red">1, 2, 3</b>. Then related posts will be displayed after paragraphs 1, 2 and 3.', 'lokerpro' ),
		'priority'    => 90,
	);

	$section    = 'metapost';
	$sections[] = array(
		'id'       => $section,
		'title'    => __( 'Meta Post', 'lokerpro' ),
		'priority' => 50,
		'panel'    => $panel_blog,
	);

	$options[ $pjsprefix . '_active-totalopeningjob' ] = array(
		'id'      => $pjsprefix . '_active-totalopeningjob',
		'label'   => __( 'Hide Total Opening Job', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-viewedby' ] = array(
		'id'      => $pjsprefix . '_active-viewedby',
		'label'   => __( 'Hide Viewed by', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-postedon' ] = array(
		'id'      => $pjsprefix . '_active-postedon',
		'label'   => __( 'Hide Posted on', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-postedby' ] = array(
		'id'      => $pjsprefix . '_active-postedby',
		'label'   => __( 'Hide Posted by', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-publisheddate' ] = array(
		'id'      => $pjsprefix . '_active-publisheddate',
		'label'   => __( 'Hide Published Date', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-category' ] = array(
		'id'      => $pjsprefix . '_active-category',
		'label'   => __( 'Hide Category', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-joblocation' ] = array(
		'id'      => $pjsprefix . '_active-joblocation',
		'label'   => __( 'Hide Job Location', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-employmenttype' ] = array(
		'id'      => $pjsprefix . '_active-employmenttype',
		'label'   => __( 'Hide Employment Type', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-educationrequirements' ] = array(
		'id'      => $pjsprefix . '_active-educationrequirements',
		'label'   => __( 'Hide Education Requirements', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-experiencerequirements' ] = array(
		'id'      => $pjsprefix . '_active-experiencerequirements',
		'label'   => __( 'Hide Experience Requirements', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-imagegallery' ] = array(
		'id'      => $pjsprefix . '_active-imagegallery',
		'label'   => __( 'Hide Image Gallery', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-closingdate' ] = array(
		'id'      => $pjsprefix . '_active-closingdate',
		'label'   => __( 'Hide Closing Date', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-tagpost' ] = array(
		'id'      => $pjsprefix . '_active-tagpost',
		'label'   => __( 'Hide Tag Post', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-authorbox' ] = array(
		'id'      => $pjsprefix . '_active-authorbox',
		'label'   => __( 'Hide Author Box', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$section    = 'applycontent';
	$sections[] = array(
		'id'       => $section,
		'title'    => __( 'Apply Page', 'lokerpro' ),
		'priority' => 50,
		'panel'    => $panel_blog,
	);

	$options[ $pjsprefix . '_active-safelink-content' ] = array(
		'id'      => $pjsprefix . '_active-safelink-content',
		'label'   => __( 'Activate Safelink In Apply Page', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_timer-safelink' ] = array(
		'id'      => $pjsprefix . '_timer-safelink',
		'label'   => __( 'Timer Safelink', 'lokerpro' ),
		'section' => $section,
		'type'	  =>'number',
		'input_attrs' => array(
				        'min' =>1,
				        ),
		'default' => 5,
		'priority'=> 60,
		'description' => __( 'Enter the safelink waiting time.', 'lokerpro' ),
	);


	/*
	 * Banner Section Options
	 *
	 * @since v.1.0.0
	 */
	$panel_banner = 'panel-banner';
	$panels[]     = array(
		'id'       => $panel_banner,
		'title'    => __( 'Banner', 'lokerpro' ),
		'priority' => '50',
	);


				$section    = 'topads';
				$sections[] = array(
					'id'          => $section,
					'title'       => __( 'Top Banner After Menu', 'lokerpro' ),
					'priority'    => 50,
					'panel'       => $panel_banner,
					'description' => __( 'Insert your banner after menu. For an example banner, you can enter this code:<br><b style="color: red;">&lt;img src=&quot;https://demo.pojoksoft.com/lokerpro/wp-content/uploads/2024/04/tsel.webp&quot; width=&quot;100%&quot; /&gt;</b><br><br>', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_adsaftermenu' ] = array(
					'id'          => $pjsprefix . '_adsaftermenu',
					'label'       => __( 'HTML code.', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'textareajsallowed',
					'priority'    => 60,
					'description' => __( 'Please insert your html code, adsense code or other ads code here. This option support shortcode too.', 'lokerpro' ),
				);

				$section    = 'betweenpostads';
				$sections[] = array(
					'id'          => $section,
					'title'       => __( 'Banner Between Posts', 'lokerpro' ),
					'priority'    => 50,
					'panel'       => $panel_banner,
					'description' => __( 'Insert your banner between post in archive page. For an example banner, you can enter this code:<br><b style="color: red;">&lt;img src=&quot;https://demo.pojoksoft.com/lokerpro/wp-content/uploads/2024/04/yamaha.gif&quot; width=&quot;468&quot; height=&quot;60&quot; /&gt;</b><br><br>', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_adsbetweenpost' ] = array(
					'id'          => $pjsprefix . '_adsbetweenpost',
					'label'       => __( 'HTML code.', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'textareajsallowed',
					'priority'    => 60,
					'description' => __( 'Please insert your html code, adsense code or other ads code here. This option support shortcode too.', 'lokerpro' ),
				);

				$afterpostlocation                                 = array(
					'first'  => __( 'After First Post', 'lokerpro' ),
					'second' => __( 'After Second Post', 'lokerpro' ),
					'third'  => __( 'After Third Post', 'lokerpro' ),
					'fourth' => __( 'After Fourth Post', 'lokerpro' ),
				);
				$options[ $pjsprefix . '_adsbetweenpostposition' ] = array(
					'id'      => $pjsprefix . '_adsbetweenpostposition',
					'label'   => __( 'Banner Position', 'lokerpro' ),
					'section' => $section,
					'type'    => 'radio',
					'choices' => $afterpostlocation,
					'default' => 'third',
				);

				$section    = 'beforecontentads';
				$sections[] = array(
					'id'          => $section,
					'title'       => __( 'Banner Before Content', 'lokerpro' ),
					'priority'    => 50,
					'panel'       => $panel_banner,
					'description' => __( 'Insert your banner before single content. For an example banner, you can enter this code:<br><b style="color: red;">&lt;img src=&quot;https://demo.pojoksoft.com/lokerpro/wp-content/uploads/2024/04/holidaysingapore.gif&quot; width=&quot;100%&quot; /&gt;</b><br><br>', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_adsbeforecontent' ] = array(
					'id'          => $pjsprefix . '_adsbeforecontent',
					'label'       => __( 'HTML code.', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'textareajsallowed',
					'priority'    => 60,
					'description' => __( 'Please insert your html code, adsense code or other ads code here. This option support shortcode too.', 'lokerpro' ),
				);

				$locationbanner                                      = array(
					'default'    => __( 'Default', 'lokerpro' ),
					'floatleft'  => __( 'Float Left', 'lokerpro' ),
					'floatright' => __( 'Float Right', 'lokerpro' ),
					'center'     => __( 'Center', 'lokerpro' ),
				);
				$options[ $pjsprefix . '_adsbeforecontentposition' ] = array(
					'id'      => $pjsprefix . '_adsbeforecontentposition',
					'label'   => __( 'Banner Position', 'lokerpro' ),
					'section' => $section,
					'type'    => 'radio',
					'choices' => $locationbanner,
					'default' => 'default',
				);

				$section    = 'insidecontentads';
				$sections[] = array(
					'id'          => $section,
					'title'       => __( 'Banner Inside Content', 'lokerpro' ),
					'priority'    => 50,
					'panel'       => $panel_banner,
					'description' => __( 'Insert your banner inside content in single post. For an example banner, you can enter this code:<br><b style="color: red;">&lt;img width=&quot;300&quot; height=&quot;600&quot; src=&quot;https://demo.pojoksoft.com/lokerpro/wp-content/uploads/2024/04/design4223.jpg&quot; /&gt;</b><br><br>', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_adsinsidecontent' ] = array(
					'id'          => $pjsprefix . '_adsinsidecontent',
					'label'       => __( 'HTML code.', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'textareajsallowed',
					'priority'    => 60,
					'description' => __( 'Please insert your html code, adsense code or other ads code here. This option support shortcode too.', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_adsinsidecontentlocation' ] = array(
					'id'          => $pjsprefix . '_adsinsidecontentlocation',
					'label'       => __( 'Banner/Ads Position.', 'lokerpro' ),
					'section'     => $section,
				     'type'		  =>'number',
				        			'input_attrs' => array(
				          				'min' =>1,
				        			 ),
					'priority'    => 60,
					'description' => __( 'The position after the paragraph where the banner/ads is displayed.', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_textparallax' ] = array(
					'id'          => $pjsprefix . '_textparallax',
					'label'       => __( 'Text Above Parallax Box', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'text',
					'priority'    => 60,
				);

				$options[ $pjsprefix . '_textparallaxbawah' ] = array(
					'id'          => $pjsprefix . '_textparallaxbawah',
					'label'       => __( 'Text Below Parallax Box', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'text',
					'priority'    => 60,
				);

				$locationbanner                                      = array(
					'left'   => __( 'Left', 'lokerpro' ),
					'right'  => __( 'Right', 'lokerpro' ),
					'center' => __( 'Center', 'lokerpro' ),
				);

				$section    = 'aftercontentads';
				$sections[] = array(
					'id'          => $section,
					'title'       => __( 'Banner After Content', 'lokerpro' ),
					'priority'    => 50,
					'panel'       => $panel_banner,
					'description' => __( 'Insert your banner after content in single post. For an example banner, you can enter this code:<br><b style="color: red;">&lt;img src=&quot;https://demo.pojoksoft.com/lokerpro/wp-content/uploads/2024/04/yamaha.gif&quot; width=&quot;100%&quot; /&gt;</b><br><br>', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_adsaftercontent' ] = array(
					'id'          => $pjsprefix . '_adsaftercontent',
					'label'       => __( 'HTML code.', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'textareajsallowed',
					'priority'    => 60,
					'description' => __( 'Please insert your html code, adsense code or other ads code here. This option support shortcode too.', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_adsaftercontentposition' ] = array(
					'id'      => $pjsprefix . '_adsaftercontentposition',
					'label'   => __( 'Banner Position', 'lokerpro' ),
					'section' => $section,
					'type'    => 'radio',
					'choices' => $locationbanner,
					'default' => 'left',
				);

				$section    = 'afterrelpostads';
				$sections[] = array(
					'id'          => $section,
					'title'       => __( 'Banner After Related Posts', 'lokerpro' ),
					'priority'    => 50,
					'panel'       => $panel_banner,
					'description' => __( 'Insert your banner after related posts in single post. For an example banner, you can enter this code:<br><b style="color: red;">&lt;img src=&quot;https://demo.pojoksoft.com/lokerpro/wp-content/uploads/2024/04/indomie.jpg&quot; width=&quot;100%&quot; /&gt;</b><br><br>', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_adsafterrelpost' ] = array(
					'id'          => $pjsprefix . '_adsafterrelpost',
					'label'       => __( 'HTML code.', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'textareajsallowed',
					'priority'    => 60,
					'description' => __( 'Please insert your html code, adsense code or other ads code here. This option support shortcode too.', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_adsafterrelpostposition' ] = array(
					'id'      => $pjsprefix . '_adsafterrelpostposition',
					'label'   => __( 'Banner Position', 'lokerpro' ),
					'section' => $section,
					'type'    => 'radio',
					'choices' => $locationbanner,
					'default' => 'left',
				);

				$section    = 'floatleftads';
				$sections[] = array(
					'id'          => $section,
					'title'       => __( 'Floating Left Ads', 'lokerpro' ),
					'priority'    => 50,
					'panel'       => $panel_banner,
					'description' => __( 'Insert your banner floating left in all page. For an example banner, you can enter this code:<br><b style="color: red;">&lt;img  src=&quot;https://demo.pojoksoft.com/lokerpro/wp-content/uploads/2024/04/ayla.jpg&quot; width=&quot;120&quot; height=&quot;600&quot; /&gt;</b><br><br>', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_adsfloatleft' ] = array(
					'id'          => $pjsprefix . '_adsfloatleft',
					'label'       => __( 'HTML code.', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'textareajsallowed',
					'priority'    => 60,
					'description' => __( 'Please insert your html code, adsense code or other ads code here. This option support shortcode too.', 'lokerpro' ),
				);

				$section    = 'floatrightads';
				$sections[] = array(
					'id'          => $section,
					'title'       => __( 'Floating Right Ads', 'lokerpro' ),
					'priority'    => 50,
					'panel'       => $panel_banner,
					'description' => __( 'Insert your banner floating right in all page. For an example banner, you can enter this code:<br><b style="color: red;">&lt;img  src=&quot;https://demo.pojoksoft.com/lokerpro/wp-content/uploads/2024/04/ayla.jpg&quot; width=&quot;120&quot; height=&quot;600&quot; /&gt;</b><br><br>', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_adsfloatright' ] = array(
					'id'          => $pjsprefix . '_adsfloatright',
					'label'       => __( 'HTML code.', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'textareajsallowed',
					'priority'    => 60,
					'description' => __( 'Please insert your html code, adsense code or other ads code here. This option support shortcode too.', 'lokerpro' ),
				);

				$section                                   = 'floatbottomads';
				$sections[]                                = array(
					'id'          => $section,
					'title'       => __( 'Floating Bottom Ads', 'lokerpro' ),
					'priority'    => 50,
					'panel'       => $panel_banner,
					'description' => __( 'Insert your banner floating bottom in all page.', 'lokerpro' ),
				);
				$options[ $pjsprefix . '_adsfloatbottom' ] = array(
					'id'          => $pjsprefix . '_adsfloatbottom',
					'label'       => __( 'HTML code.', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'textareajsallowed',
					'priority'    => 60,
					'description' => __( 'Please insert your html code, adsense code or other ads code here. This option support shortcode too.', 'lokerpro' ),
				);

				$section    = 'footerads';
				$sections[] = array(
					'id'          => $section,
					'title'       => __( 'Footer Banner Before Widget', 'lokerpro' ),
					'priority'    => 50,
					'panel'       => $panel_banner,
					'description' => __( 'Insert your banner in footer before widget footer or copyright. For an example banner, you can enter this code:<br><b style="color: red;">&lt;img  src=&quot;https://demo.pojoksoft.com/lokerpro/wp-content/uploads/2024/04/freelance_engine.jpg&quot; title=&quot;banner 728x90&quot; width=&quot;728&quot; height=&quot;90&quot; /&gt;</b><br><br>', 'lokerpro' ),
				);

				$options[ $pjsprefix . '_adsfooter' ] = array(
					'id'          => $pjsprefix . '_adsfooter',
					'label'       => __( 'HTML code.', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'textareajsallowed',
					'priority'    => 60,
					'description' => __( 'Please insert your html code, adsense code or other ads code here. This option support shortcode too.', 'lokerpro' ),
				);


	/*
	 * Footer Section Options
	 *
	 * @since v.1.0.0
	 */
	$panel_footer = 'panel-footer';
	$panels[]     = array(
		'id'       => $panel_footer,
		'title'    => __( 'Footer', 'lokerpro' ),
		'priority' => '50',
	);

	$section    = 'widget_section';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Widgets Footer', 'lokerpro' ),
		'priority'    => 50,
		'panel'       => $panel_footer,
		'description' => __( 'Footer widget columns.', 'lokerpro' ),
	);

	$columns = array(
		'1' => __( '1 Column', 'lokerpro' ),
		'2' => __( '2 Columns', 'lokerpro' ),
		'3' => __( '3 Columns', 'lokerpro' ),
		'4' => __( '4 Columns', 'dlpro' ),
	);

	$options[ $pjsprefix . '_footer_column' ] = array(
		'id'      => $pjsprefix . '_footer_column',
		'label'   => __( 'Widgets Footer', 'lokerpro' ),
		'section' => $section,
		'type'    => 'radio',
		'choices' => $columns,
		'default' => '4',
	);
	
	$section    = 'social';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Social & Footer Navigation', 'lokerpro' ),
		'priority'    => 50,
		'panel'       => $panel_footer,
		'description' => __( 'Allow you add social icon and disable footer navigation.', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_active-footernavigation' ] = array(
		'id'      => $pjsprefix . '_active-topnavigation',
		'label'   => __( 'Disable footer navigation', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-rssicon' ] = array(
		'id'      => $pjsprefix . '_active-rssicon',
		'label'   => __( 'Disable RSS icon in social', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_fb_url_icon' ] = array(
		'id'          => $pjsprefix . '_fb_url_icon',
		'label'       => __( 'FB Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_twitter_url_icon' ] = array(
		'id'          => $pjsprefix . '_twitter_url_icon',
		'label'       => __( 'Twitter Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_pinterest_url_icon' ] = array(
		'id'          => $pjsprefix . '_pinterest_url_icon',
		'label'       => __( 'Pinterest Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_googleplus_url_icon' ] = array(
		'id'          => $pjsprefix . '_googleplus_url_icon',
		'label'       => __( 'Google Plus Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_tumblr_url_icon' ] = array(
		'id'          => $pjsprefix . '_tumblr_url_icon',
		'label'       => __( 'Tumblr Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_stumbleupon_url_icon' ] = array(
		'id'          => $pjsprefix . '_stumbleupon_url_icon',
		'label'       => __( 'Stumbleupon Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_wordpress_url_icon' ] = array(
		'id'          => $pjsprefix . '_wordpress_url_icon',
		'label'       => __( 'Wordpress Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_instagram_url_icon' ] = array(
		'id'          => $pjsprefix . '_instagram_url_icon',
		'label'       => __( 'Instagram Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_dribbble_url_icon' ] = array(
		'id'          => $pjsprefix . '_dribbble_url_icon',
		'label'       => __( 'Dribbble Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_vimeo_url_icon' ] = array(
		'id'          => $pjsprefix . '_vimeo_url_icon',
		'label'       => __( 'Vimeo Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_linkedin_url_icon' ] = array(
		'id'          => $pjsprefix . '_linkedin_url_icon',
		'label'       => __( 'Linkedin Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_deviantart_url_icon' ] = array(
		'id'          => $pjsprefix . '_deviantart_url_icon',
		'label'       => __( 'Deviantart Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_myspace_url_icon' ] = array(
		'id'          => $pjsprefix . '_myspace_url_icon',
		'label'       => __( 'Myspace Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_skype_url_icon' ] = array(
		'id'          => $pjsprefix . '_skype_url_icon',
		'label'       => __( 'Skype Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_youtube_url_icon' ] = array(
		'id'          => $pjsprefix . '_youtube_url_icon',
		'label'       => __( 'Youtube Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_picassa_url_icon' ] = array(
		'id'          => $pjsprefix . '_picassa_url_icon',
		'label'       => __( 'Picassa Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_flickr_url_icon' ] = array(
		'id'          => $pjsprefix . '_flickr_url_icon',
		'label'       => __( 'Flickr Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_blogger_url_icon' ] = array(
		'id'          => $pjsprefix . '_blogger_url_icon',
		'label'       => __( 'Blogger Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_spotify_url_icon' ] = array(
		'id'          => $pjsprefix . '_spotify_url_icon',
		'label'       => __( 'Spotify Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_delicious_url_icon' ] = array(
		'id'          => $pjsprefix . '_delicious_url_icon',
		'label'       => __( 'Delicious Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);
	
	$options[ $pjsprefix . '_tiktok_url_icon' ] = array(
		'id'          => $pjsprefix . '_tiktok_url_icon',
		'label'       => __( 'Tiktok Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_telegram_url_icon' ] = array(
		'id'          => $pjsprefix . '_telegram_url_icon',
		'label'       => __( 'Telegram Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_whatsapp_url_icon' ] = array(
		'id'          => $pjsprefix . '_whatsapp_url_icon',
		'label'       => __( 'Whatsapp Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$options[ $pjsprefix . '_soundcloud_url_icon' ] = array(
		'id'          => $pjsprefix . '_soundcloud_url_icon',
		'label'       => __( 'Soundcloud Url', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'url',
		'description' => __( 'Fill using http:// or https://', 'lokerpro' ),
		'priority'    => 90,
	);

	$section    = 'copyright_section';
	$sections[] = array(
		'id'       => $section,
		'title'    => __( 'Copyright', 'lokerpro' ),
		'priority' => 60,
		'panel'    => $panel_footer,
	);


				$options[ $pjsprefix . '_copyright' ] = array(
					'id'          => $pjsprefix . '_copyright',
					'label'       => __( 'Footer Copyright.', 'lokerpro' ),
					'section'     => $section,
					'type'        => 'textarea',
					'priority'    => 60,
					'description' => __( 'Display your own copyright text in footer.', 'lokerpro' ),
				);

	$section    = 'footer_color';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Footer Color', 'lokerpro' ),
		'priority'    => 60,
		'panel'       => $panel_footer,
		'description' => __( 'Allow you customize footer color style.', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_copyright-bgcolor' ] = array(
		'id'      => $pjsprefix . '_copyright-bgcolor',
		'label'   => __( 'Background Color - Copyright', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $copyright_bgcolor,
	);

	$options[ $pjsprefix . '_copyright-fontcolor' ] = array(
		'id'      => $pjsprefix . '_copyright-fontcolor',
		'label'   => __( 'Font Color - Copyright', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $copyright_fontcolor,
	);

	$options[ $pjsprefix . '_copyright-linkcolor' ] = array(
		'id'      => $pjsprefix . '_copyright-linkcolor',
		'label'   => __( 'Link Color - Copyright', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $copyright_linkcolor,
	);

	$options[ $pjsprefix . '_copyright-hoverlinkcolor' ] = array(
		'id'      => $pjsprefix . '_copyright-hoverlinkcolor',
		'label'   => __( 'Hover Link Color - Copyright', 'lokerpro' ),
		'section' => $section,
		'type'    => 'color',
		'default' => $copyright_hoverlinkcolor,
	);

	/*
	 * Other Section Options
	 *
	 * @since v.1.0.0
	 */
	$panel_other = 'panel-other';
	$panels[]    = array(
		'id'       => $panel_other,
		'title'    => __( 'Other', 'lokerpro' ),
		'priority' => '50',
	);

	$section    = 'head_script';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Head Script', 'lokerpro' ),
		'priority'    => 60,
		'panel'       => $panel_other,
		'description' => __( 'Allow you add script inside &lt;head&gt;&lt;/head&gt;.', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_head_script' ] = array(
		'id'          => $pjsprefix . '_head_script',
		'label'       => __( 'HTML code.', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'textareajsallowed',
		'priority'    => 60,
		'description' => __( 'Please insert your code here.', 'lokerpro' ),
	);

	$section    = 'footer_script';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Footer Script', 'lokerpro' ),
		'priority'    => 60,
		'panel'       => $panel_other,
		'description' => __( 'Allow you add script before &lt;/body&gt;.', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_footer_script' ] = array(
		'id'          => $pjsprefix . '_footer_script',
		'label'       => __( 'HTML code.', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'textareajsallowed',
		'priority'    => 60,
		'description' => __( 'Please insert your code here.', 'lokerpro' ),
	);

	$section    = 'analytic_script';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Analytic & Pixel', 'lokerpro' ),
		'priority'    => 60,
		'panel'       => $panel_other,
		'description' => __( 'Allow you add google analytic and facebook pixel.', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_analytic' ] = array(
		'id'          => $pjsprefix . '_analytic',
		'label'       => __( 'Google Analytics ID', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'text',
		'description' => __( 'Enter your Google Analytics ID (Ex: UA-XXXXX-X).', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_pixel' ] = array(
		'id'          => $pjsprefix . '_pixel',
		'label'       => __( 'Facebook Pixel ID', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'text',
		'description' => __( 'Enter your Facebook Pixel ID.', 'lokerpro' ),
	);

	$section    = 'other_other';
	$sections[] = array(
		'id'          => $section,
		'title'       => __( 'Other Settings', 'lokerpro' ),
		'priority'    => 60,
		'panel'       => $panel_other,
		'description' => __( 'Other Settings.', 'lokerpro' ),
	);

	$enable_disable = array(
		'enable'  => __( 'Enable', 'lokerpro' ),
		'disable' => __( 'Disable', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_active-sticky-sidebar' ] = array(
		'id'      => $pjsprefix . '_active-sticky-sidebar',
		'label'   => __( 'Disable Sticky In Sidebar', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);

	$options[ $pjsprefix . '_active-on-top-button' ] = array(
		'id'      => $pjsprefix . '_active-on-top-button',
		'label'   => __( 'Hide On Top Button', 'lokerpro' ),
		'section' => $section,
		'type'    => 'checkbox',
		'default' => 0,
	);


	$options[ $pjsprefix . '_remove_emoji_script' ] = array(
		'id'          => $pjsprefix . '_remove_emoji_script',
		'label'       => __( 'Remove Emoji Script', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'radio',
		'choices'     => $enable_disable,
		'default'     => 'disable',
		'description' => __( 'Enable this if you want remove emoji script from &lt;head&gt; section. This can improve your web performance.', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_remove_oembed' ] = array(
		'id'          => $pjsprefix . '_remove_oembed',
		'label'       => __( 'Remove WP Oembed', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'radio',
		'choices'     => $enable_disable,
		'default'     => 'disable',
		'description' => __( 'Enable this if you want remove wp oembed feature, if this conflict with some plugin please do not activated. This can improve your web performance.', 'lokerpro' ),
	);

	$options[ $pjsprefix . '_wp_head_tag' ] = array(
		'id'          => $pjsprefix . '_wp_head_tag',
		'label'       => __( 'Remove WP Head Meta Tag', 'lokerpro' ),
		'section'     => $section,
		'type'        => 'radio',
		'choices'     => $enable_disable,
		'default'     => 'disable',
		'description' => __( 'Enable this if you want remove wp head meta tag, if this conflict with some plugin please do not activated. This option can remove wp meta tag generator, rds, wlwmanifest, feed links, shortlink, comments feed so your head tag look simple and hope can fast your index.', 'lokerpro' ),
	);

	/*
	 * Call if only woocommerce actived
	 *
	 * @since v.1.0.0
	 */
	if ( class_exists( 'WooCommerce' ) ) {

		// Woocommerce options.
		$section    = 'woocommerce';
		$sections[] = array(
			'id'       => $section,
			'title'    => __( 'Woocommerce', 'lokerpro' ),
			'priority' => 100,
		);

		$columns = array(
			'2' => __( '2 Columns', 'lokerpro' ),
			'3' => __( '3 Columns', 'lokerpro' ),
			'4' => __( '4 Columns', 'lokerpro' ),
			'5' => __( '5 Columns', 'lokerpro' ),
			'6' => __( '6 Columns', 'lokerpro' ),
		);

		$options[ $pjsprefix . '_wc_column' ] = array(
			'id'      => $pjsprefix . '_wc_column',
			'label'   => __( 'Product Columns', 'lokerpro' ),
			'section' => $section,
			'type'    => 'select',
			'choices' => $columns,
			'default' => '3',
		);

		$sidebar = array(
			'sidebar'   => __( 'Sidebar', 'lokerpro' ),
			'fullwidth' => __( 'Fullwidth', 'lokerpro' ),
		);

		$options[ $pjsprefix . '_wc_sidebar' ] = array(
			'id'      => $pjsprefix . '_wc_sidebar',
			'label'   => __( 'Woocommerce Sidebar', 'lokerpro' ),
			'section' => $section,
			'type'    => 'radio',
			'choices' => $sidebar,
			'default' => 'sidebar',
		);

		$product_per_page = array(
			'6'  => __( '6 Products', 'lokerpro' ),
			'7'  => __( '7 Products', 'lokerpro' ),
			'8'  => __( '8 Products', 'lokerpro' ),
			'9'  => __( '9 Products', 'lokerpro' ),
			'10' => __( '10 Products', 'lokerpro' ),
			'11' => __( '11 Products', 'lokerpro' ),
			'12' => __( '12 Products', 'lokerpro' ),
			'13' => __( '13 Products', 'lokerpro' ),
			'14' => __( '14 Products', 'lokerpro' ),
			'15' => __( '15 Products', 'lokerpro' ),
			'16' => __( '16 Products', 'lokerpro' ),
			'17' => __( '17 Products', 'lokerpro' ),
			'18' => __( '18 Products', 'lokerpro' ),
			'19' => __( '19 Products', 'lokerpro' ),
			'20' => __( '20 Products', 'lokerpro' ),
			'21' => __( '21 Products', 'lokerpro' ),
			'22' => __( '22 Products', 'lokerpro' ),
			'23' => __( '23 Products', 'lokerpro' ),
			'24' => __( '24 Products', 'lokerpro' ),
			'25' => __( '25 Products', 'lokerpro' ),
			'26' => __( '26 Products', 'lokerpro' ),
			'27' => __( '27 Products', 'lokerpro' ),
			'28' => __( '28 Products', 'lokerpro' ),
			'29' => __( '29 Products', 'lokerpro' ),
			'30' => __( '30 Products', 'lokerpro' ),
		);

		$options[ $pjsprefix . '_wc_productperpage' ] = array(
			'id'      => $pjsprefix . '_wc_productperpage',
			'label'   => __( 'Woocommerce Product Per Page', 'lokerpro' ),
			'section' => $section,
			'type'    => 'select',
			'choices' => $product_per_page,
			'default' => '9',
		);

		$options[ $pjsprefix . '_active-cartbutton' ] = array(
			'id'      => $pjsprefix . '_active-cartbutton',
			'label'   => __( 'Remove Cart button from menu', 'lokerpro' ),
			'section' => $section,
			'type'    => 'checkbox',
			'default' => 0,
		);

	}

	// Adds the sections to the $options array.
	$options['sections'] = $sections;
	// Adds the panels to the $options array.
	$options['panels']  = $panels;
	$customizer_library = Customizer_Library::Instance();
	$customizer_library->add_options( $options );
	// To delete custom mods use: customizer_library_remove_theme_mods();.
}
add_action( 'init', 'pjs_library_options_customizer' );

if ( ! function_exists( 'customizer_library_demo_build_styles' ) && class_exists( 'Customizer_Library_Styles' ) ) :
	/**
	 * Process user options to generate CSS needed to implement the choices.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	function pjs_library_customizer_build_styles() {

		// Content Background Color.
		$setting = 'pjs_content-color';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'body',
						'.software-link-tab > li.active > a',
					),
					'declarations' => array(
						'color' => $color,
					),
				)
			);
		}

		// Content Parallax Background Color.
		$setting = 'pjs_prlbackg';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.parallxads',
					),
					'declarations' => array(
						'background' => $color,
					),
				)
			);
		}

		// Content Parallax Box Color.
		$setting = 'pjs_prlbackgbox';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.parallxads:before', '.parallxads:after'
					),
					'declarations' => array(
						'background' => $color,
					),
				)
			);
		}

		// Content Parallax Box Color.
		$setting = 'pjs_ontopcolor';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.pjs-ontop'
					),
					'declarations' => array(
						'color' => $color,
					),
				)
			);
		}

		// Color scheme.
		$setting = 'pjs_scheme-color';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'kbd',
						'a.button',
						'button',
						'.button',
						'button.button',
						'input[type="button"]',
						'input[type="reset"]',
						'input[type="submit"]',
						'ul.page-numbers li a:hover',
						'ul.page-numbers li span.page-numbers',
						'.page-links .page-link-number',
						'.page-links a .page-link-number:hover',
						'.tagcloud a:hover',
						'.tagcloud a:focus',
						'.tagcloud a:active',
						'.text-marquee',
					),
					'declarations' => array(
						'background-color' => $color,
					),
				)
			);

			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.content-area',
						'.sidebar-layout .widget',
						'.widget-home .widget',
					),
					'declarations' => array(
						'border-top' => '0px solid ' . $color,
					),
				)
			);

			if ( class_exists( 'WooCommerce' ) ) {

				$color = sanitize_hex_color( $mod );
				Customizer_Library_Styles()->add(
					array(
						'selectors'    => array(
							'.woocommerce #respond input#submit',
							'.woocommerce a.button',
							'.woocommerce button.button',
							'.woocommerce input.button',
							'.woocommerce #respond input#submit:hover',
							'.woocommerce a.button:hover',
							'.woocommerce button.button:hover',
							'.woocommerce input.button:hover',
							'.woocommerce #respond input#submit:focus',
							'.woocommerce a.button:focus',
							'.woocommerce button.button:focus',
							'.woocommerce input.button:focus',
							'.woocommerce #respond input#submit:active',
							'.woocommerce a.button:active',
							'.woocommerce button.button:active',
							'.woocommerce input.button:active',
							'.woocommerce #respond input#submit.alt:hover',
							'.woocommerce a.button.alt:hover',
							'.woocommerce button.button.alt:hover',
							'.woocommerce input.button.alt:hover',
							'.woocommerce #respond input#submit.alt:focus',
							'.woocommerce a.button.alt:focus',
							'.woocommerce button.button.alt:focus',
							'.woocommerce input.button.alt:focus',
							'.woocommerce #respond input#submit.alt:active',
							'.woocommerce a.button.alt:active',
							'.woocommerce button.button.alt:active',
							'.woocommerce input.button.alt:active',
							'.woocommerce #respond input#submit.alt',
							'.woocommerce a.button.alt',
							'.woocommerce button.button.alt',
							'.woocommerce input.button.alt',
						),
						'declarations' => array(
							'background-color' => $color,
						),
					)
				);

			}

			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.tagcloud a',
						'.sticky .pjs-box-content',
						'.pjs-theme div.lokerpro-related-post h3.related-title:after',
						'.page-title:after',
						'.widget-title:after',
						'h3.comment-reply-title:after',
						'.bypostauthor > .comment-body',
					),
					'declarations' => array(
						'border-color' => $color,
					),
				)
			);

		}

		// Link Color.
		$setting = 'pjs_link-color';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {

			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'a',
						'h2.post-title a',
					),
					'declarations' => array(
						'color' => $color,
					),
				)
			);

		}

		$setting = 'pjs_hover-link-color';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {

			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'a:hover',
						'a:focus',
						'a:active',
						'h2.post-title a:hover',
						'h2.post-title a:focus',
						'h2.post-title a:active',
					),
					'declarations' => array(
						'color' => $color,
					),
				)
			);

		}

		// Header Background image.
		$url     = has_header_image() ? get_header_image() : get_theme_support( 'custom-header', 'default-image' );
		$setting = 'pjs_active-headerimage';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( 0 === $mod ) {
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.pjs-headwrapper',
					),
					'declarations' => array(
						'background-image' => 'url(' . $url . ')',
					),
				)
			);

			// Header Background Size.
			$setting = 'pjs_headerimage_bgsize';
			$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
			if ( $mod ) {
				$bgsize = wp_filter_nohtml_kses( $mod );
				Customizer_Library_Styles()->add(
					array(
						'selectors'    => array(
							'.pjs-headwrapper',
						),
						'declarations' => array(
							'-webkit-background-size' => $bgsize,
							'-moz-background-size'    => $bgsize,
							'-o-background-size'      => $bgsize,
							'background-size'         => $bgsize,
						),
					)
				);
			}

			// Header Background Repeat.
			$setting = 'pjs_headerimage_bgrepeat';
			$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
			if ( $mod ) {
				$bgrepeat = wp_filter_nohtml_kses( $mod );
				Customizer_Library_Styles()->add(
					array(
						'selectors'    => array(
							'.pjs-headwrapper',
						),
						'declarations' => array(
							'background-repeat' => $bgrepeat,
						),
					)
				);
			}

			// Header Background Position.
			$setting = 'pjs_headerimage_bgposition';
			$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
			if ( $mod ) {
				$bgposition = wp_filter_nohtml_kses( $mod );
				Customizer_Library_Styles()->add(
					array(
						'selectors'    => array(
							'.pjs-headwrapper',
						),
						'declarations' => array(
							'background-position' => $bgposition,
						),
					)
				);
			}

			// Header Background Position.
			$setting = 'pjs_headerimage_bgattachment';
			$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
			if ( $mod ) {
				$bgattachment = wp_filter_nohtml_kses( $mod );
				Customizer_Library_Styles()->add(
					array(
						'selectors'    => array(
							'.pjs-headwrapper',
						),
						'declarations' => array(
							'background-attachment' => $bgattachment,
						),
					)
				);
			}
		}

		// Header Background Color.
		$setting = 'pjs_header-bgcolor';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.pjs-headwrapper',
					),
					'declarations' => array(
						'background-color' => $color,
					),
				)
			);
		}

		// site title.
		$setting = 'pjs_sitetitle-color';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.site-title a',
					),
					'declarations' => array(
						'color' => $color,
					),
				)
			);
		}

		// site description.
		$setting = 'pjs_sitedesc-color';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.site-description',
					),
					'declarations' => array(
						'color' => $color,
					),
				)
			);
		}

		$setting = 'pjs_mainmenu-bgcolor';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.pjs-menuwrap',
						'.pjs-mainmenu #primary-menu .sub-menu',
						'.pjs-mainmenu #primary-menu .children',
					),
					'declarations' => array(
						'background-color' => $color,
					),
				)
			);
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.pjs-mainmenu #primary-menu .sub-menu:after',
						'.pjs-mainmenu #primary-menu .children:after',
					),
					'declarations' => array(
						'border-bottom-color' => $color,
					),
				)
			);
		}

		// Menu text color.
		$setting = 'pjs_mainmenu-color';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'#pjs-responsive-menu',
						'.pjs-mainmenu #primary-menu > li > a',
						'.pjs-mainmenu #primary-menu .sub-menu > li > a',
						'.pjs-mainmenu #primary-menu .children > li > a',
					),
					'declarations' => array(
						'color' => $color,
					),
				)
			);

			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'#primary-menu > li.menu-border > a span',
						'.pjs-mainmenu #primary-menu > li.page_item_has_children > a:after',
						'.pjs-mainmenu #primary-menu > li.menu-item-has-children > a:after',
						'.pjs-mainmenu #primary-menu .sub-menu > li.page_item_has_children > a:after',
						'.pjs-mainmenu #primary-menu .sub-menu > li.menu-item-has-children > a:after',
					),
					'declarations' => array(
						'border-color' => $color,
					),
				)
			);
		}

		// Hover text color.
		$setting = 'pjs_hovermenu-color';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'#pjs-responsive-menu:hover',
						'.pjs-mainmenu #primary-menu > li:hover > a',
						'.pjs-mainmenu #primary-menu li.current-menu-item > a',
						'.pjs-mainmenu #primary-menu .current-menu-ancestor > a',
						'.pjs-mainmenu #primary-menu .current_page_item > a',
						'.pjs-mainmenu #primary-menu .current_page_ancestor > a',
						'.pjs-mainmenu #primary-menu .sub-menu > li:hover > a',
						'.pjs-mainmenu #primary-menu .children > li:hover > a',
					),
					'declarations' => array(
						'color' => $color,
					),
				)
			);

			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.pjs-mainmenu #primary-menu > li.menu-border:hover > a span',
						'.pjs-mainmenu #primary-menu > li.menu-border.current-menu-item > a span',
						'.pjs-mainmenu #primary-menu > li.menu-border.current-menu-ancestor > a span',
						'.pjs-mainmenu #primary-menu > li.menu-border.current_page_item > a span',
						'.pjs-mainmenu #primary-menu > li.menu-border.current_page_ancestor > a span',
						'.pjs-mainmenu #primary-menu > li.page_item_has_children:hover > a:after',
						'.pjs-mainmenu #primary-menu > li.menu-item-has-children:hover > a:after',
						'.pjs-mainmenu #primary-menu .sub-menu > li.page_item_has_children:hover > a:after',
						'.pjs-mainmenu #primary-menu .sub-menu > li.menu-item-has-children:hover > a:after',
					),
					'declarations' => array(
						'border-color' => $color,
					),
				)
			);

		}

		$setting = 'pjs_mainmenu-hoverbgcolor';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );

		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.pjs-mainmenu #primary-menu > li:hover > a',
						'.pjs-mainmenu #primary-menu li.current-menu-item > a',
						'.pjs-mainmenu #primary-menu .current-menu-ancestor > a',
						'.pjs-mainmenu #primary-menu .current_page_item > a',
						'.pjs-mainmenu #primary-menu .current_page_ancestor > a',
						'.pjs-mainmenu #primary-menu .sub-menu > li:hover > a',
						'.pjs-mainmenu #primary-menu .children > li:hover > a',
					),
					'declarations' => array(
						'background-color' => $color,
					),
				)
			);
		}

		// Primary Font.
		$setting = 'pjs_primary-font';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		$stack   = customizer_library_get_font_stack( $mod );
		if ( $mod ) {
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'h1',
						'h2',
						'h3',
						'h4',
						'h5',
						'h6',
						'.h1',
						'.h2',
						'.h3',
						'.h4',
						'.h5',
						'.h6',
						'.site-title',
						'#pjs-responsive-menu',
						'#primary-menu > li > a',
					),
					'declarations' => array(
						'font-family' => $stack,
					),
				)
			);
		}

		$setting = 'pjs_primary-font-weight';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$size = absint( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'h1',
						'h2',
						'h3',
						'h4',
						'h5',
						'h6',
						'.h1',
						'.h2',
						'.h3',
						'.h4',
						'.h5',
						'.h6',
						'.site-title',
						'#pjs-responsive-menu',
						'.widget a',
						'#primary-menu > li > a',
						'.lokerpro-rp-title',
						'.entry-meta a',
					),
					'declarations' => array(
						'font-weight' => $size,
					),
				)
			);
		}

		// Secondary Font.
		$setting = 'pjs_secondary-font';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		$stack   = customizer_library_get_font_stack( $mod );
		if ( $mod ) {
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'body',
					),
					'declarations' => array(
						'font-family' => $stack,
					),
				)
			);
		}

		$setting = 'pjs_secondary-font-weight';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$size = absint( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'body',
					),
					'declarations' => array(
						'font-weight' => $size,
					),
				)
			);
		}

		// body size.
		$setting = 'pjs_body_size';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$size = absint( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'body',
					),
					'declarations' => array(
						'font-size' => $size . 'px',
					),
				)
			);
		}

		// Copyright Background Color.
		$setting = 'pjs_copyright-bgcolor';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.site-footer',
					),
					'declarations' => array(
						'background-color' => $color,
					),
				)
			);
		}

		// Copyright Font Color.
		$setting = 'pjs_copyright-fontcolor';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.site-footer',
					),
					'declarations' => array(
						'color' => $color,
					),
				)
			);
		}

		// Copyright Link Color.
		$setting = 'pjs_copyright-linkcolor';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'#pjs-secondaryresponsive-menu',
						'.pjs-secondmenu #primary-menu > li > a',
						'.pjs-social-icon ul > li > a',
						'.site-footer a',
					),
					'declarations' => array(
						'color' => $color,
					),
				)
			);
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.pjs-secondmenu #primary-menu > li.menu-border > a span',
						'.pjs-social-icon ul > li > a',
						'.pjs-secondmenuwrap',
					),
					'declarations' => array(
						'border-color' => $color,
					),
				)
			);
		}

		// copyright Hover Link Color.
		$setting = 'pjs_copyright-hoverlinkcolor';
		$mod     = get_theme_mod( $setting, customizer_library_get_default( $setting ) );
		if ( $mod ) {
			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.site-footer a:hover',
						'#pjs-secondaryresponsive-menu:hover',
						'.pjs-secondmenu #primary-menu > li:hover > a',
						'.pjs-secondmenu #primary-menu .current-menu-item > a',
						'.pjs-secondmenu #primary-menu .current-menu-ancestor > a',
						'.pjs-secondmenu #primary-menu .current_page_item > a',
						'.pjs-secondmenu #primary-menu .current_page_ancestor > a',
						'.pjs-social-icon ul > li > a:hover',
					),
					'declarations' => array(
						'color' => $color,
					),
				)
			);

			$color = sanitize_hex_color( $mod );
			Customizer_Library_Styles()->add(
				array(
					'selectors'    => array(
						'.pjs-secondmenu #primary-menu > li.menu-border:hover > a span',
						'.pjs-secondmenu #primary-menu > li.menu-border.current-menu-item > a span',
						'.pjs-secondmenu #primary-menu > li.menu-border.current-menu-ancestor > a span',
						'.pjs-secondmenu #primary-menu > li.menu-border.current_page_item > a span',
						'.pjs-secondmenu #primary-menu > li.menu-border.current_page_ancestor > a span',
						'.pjs-social-icon ul > li > a:hover',
					),
					'declarations' => array(
						'border-color' => $color,
					),
				)
			);
		}
	}
endif; // endif pjs_library_customizer_build_styles.
add_action( 'customizer_library_styles', 'pjs_library_customizer_build_styles' );

if ( ! function_exists( 'customizer_library_demo_styles' ) ) :
	/**
	 * Generates the style tag and CSS needed for the theme options.
	 *
	 * By using the "Customizer_Library_Styles" filter, different components can print CSS in the header.
	 * It is organized this way to ensure there is only one "style" tag.
	 *
	 * @since 1.0.0
	 *
	 * @return void
	 */
	function pjs_library_customizer_styles() {
		do_action( 'customizer_library_styles' );
		// Echo the rules.
		$css = Customizer_Library_Styles()->build();
		if ( ! empty( $css ) ) {
			wp_add_inline_style( 'lokerpro-style', $css );
		}
	}
endif; // endif pjs_library_customizer_styles.
add_action( 'wp_enqueue_scripts', 'pjs_library_customizer_styles' );

if ( ! function_exists( 'pjs_remove_customizer_register' ) ) :
	/**
	 * Add postMessage support for site title and description for the Theme Customizer.
	 *
	 * @since 1.0.0
	 *
	 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
	 */
	function pjs_remove_customizer_register( $wp_customize ) {
		$wp_customize->remove_control( 'display_header_text' );
	}
endif; // endif pjs_remove_customizer_register.
add_action( 'customize_register', 'pjs_remove_customizer_register' );