<?php
/**
 * Jetpack Compatibility File.
 *
 * @link https://jetpack.com/
 *
 * @package Lokerpro
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'pjs_jetpack_setup' ) ) :
	/**
	 * Jetpack setup function.
	 *
	 * @since 1.0.0
	 *
	 * See: https://jetpack.com/support/infinite-scroll/
	 * See: https://jetpack.com/support/responsive-videos/
	 */
	function pjs_jetpack_setup() {
		// Add theme support for Infinite Scroll.
		add_theme_support(
			'infinite-scroll',
			array(
				'container' => 'main',
				'render'    => 'pjs_infinite_scroll_render',
				'footer'    => false,
				'wrapper'   => false,
			)
		);

		// Add theme support for Responsive Videos.
		add_theme_support( 'jetpack-responsive-videos' );
	}
endif; // endif pjs_jetpack_setup.
add_action( 'after_setup_theme', 'pjs_jetpack_setup' );

if ( ! function_exists( 'pjs_infinite_scroll_render' ) ) :
	/**
	 * Custom render function for Infinite Scroll.
	 *
	 * @since 1.0.0
	 */
	function pjs_infinite_scroll_render() {
		while ( have_posts() ) {
			the_post();
			get_template_part( 'template-parts/content', get_post_format() );
		}
	}
endif; // endif pjs_infinite_scroll_render.

if ( ! function_exists( 'pjs_custom_infinite_support' ) ) :
	/**
	 * Support infinite scroll only on post type "post" other post type return false
	 *
	 * @since  1.0.0
	 *
	 * @return bool
	 */
	function pjs_custom_infinite_support() {
		$supported = current_theme_supports( 'infinite-scroll' ) && ( 'post' === get_post_type() );
		return $supported;
	}
endif; // endif pjs_custom_infinite_support.
add_filter( 'infinite_scroll_archive_supported', 'pjs_custom_infinite_support' );
