<?php
/**
 * Rating Filter File.
 *
 * @link https://blazzdev.com/documentation/rate-my-post-documentation/#getting-started
 *
 * @package Lokerpro
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'lokerpro_remove_ratingarchive' ) ) :
	/**
	 * Remove rating in archive, because we use shortcode for displaying it.
	 */
	function lokerpro_remove_ratingarchive() {
		return false;
	}
endif; // endif pjs_jetpack_setup.
add_filter( 'rmp_archive_results', 'lokerpro_remove_ratingarchive' );

if ( ! function_exists( 'lokerpro_modify_rmp_strings' ) ) :
	/**
	 * Change title rating.
	 *
	 * @param array $strings_array String title.
	 * @return array
	 */
	function lokerpro_modify_rmp_strings( $strings_array ) {
		// modify only for Book custom post type.
		if ( is_singular( 'post' ) ) {
			$strings_array['rateTitle']        = __( 'Rating', 'lokerpro' );
			$strings_array['rateSubtitle']     = '';
			$strings_array['afterVote']        = __( 'Thank you for rating this software', 'lokerpro' );
			$strings_array['socialTitle']      = __( 'As you found this software useful...', 'lokerpro' );
			$strings_array['feedbackTitle']    = __( 'How come you did not like this software?', 'lokerpro' );
			$strings_array['feedbackSubtitle'] = __( 'How could this software be improved?', 'lokerpro' );
			$strings_array['feedbackText']     = __( 'Give us some tips...', 'lokerpro' );
		}
		return $strings_array;
	}
endif;
add_filter( 'rmp_custom_strings', 'lokerpro_modify_rmp_strings' );
