<?php
/**
 * The template for displaying archive pages.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Lokerpro
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

get_header();

?>

<div id="primary" class="col-md-8">
	<div class="content-area">
	<?php do_action( 'lokerpro_view_breadcrumbs' ); ?>
	<?php
		echo '<h1 class="page-title" ' . lokerpro_itemprop_schema( 'headline' ) . '>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		the_archive_title();
		echo '</h1>';

		// display description archive page.
		the_archive_description( '<div class="taxonomy-description">', '</div>' );
	?>

	<main id="main" class="site-main pjs-infinite-selector" role="main">

	<?php
	if ( have_posts() ) {

			echo '<div id="infinite-container">';

		/* Start the Loop */
		while ( have_posts() ) :
			the_post();

			/*
			 * Include the Post-Format-specific template for the content.
			 * If you want to override this in a child theme, then include a file
			 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
			 */
			get_template_part( 'template-parts/content', 'blogs' );
			do_action( 'lokerpro_banner_between_posts' );

		endwhile;

		echo '</div>';

				$loadmore = get_theme_mod( 'pjs_blog_pagination', 'pjs-more' );
				if ( ( 'pjs-infinite' === $loadmore || 'pjs-more' === $loadmore ) ) {
					$class = 'inf-pagination';
				} else {
					$class = 'pagination';
				}

				the_posts_pagination(
					array(
						'class'     => esc_html( $class ),
						'mid_size'  => 1,
						'prev_text' => '&laquo; ' . esc_html__( 'Back', 'lokerpro' ),
						'next_text' => esc_html__( 'Next', 'lokerpro' ) . ' &raquo;',
					)
				);

				if ( ( 'pjs-infinite' === $loadmore || 'pjs-more' === $loadmore ) ) {
					echo '
					<div class="text-center">
						<div class="page-load-status">
							<div class="loader-ellips infinite-scroll-request pjs-ajax-load-wrapper pjs-loader">
								<div class="pjs-loaderwrap">
									<div class="pjs-ajax-loader">
										<div class="pjs-loader1"></div>
										<div class="pjs-loader2"></div>
										<div class="pjs-loader3"></div>
										<div class="pjs-loader4"></div>
									</div>
								</div>
							</div>
							<p class="infinite-scroll-last">' . esc_attr__( 'No More Posts Available.', 'lokerpro' ) . '</p>
							<p class="infinite-scroll-error">' . esc_attr__( 'No more pages to load.', 'lokerpro' ) . '</p>
						</div>';
					if ( 'pjs-more' === $loadmore ) {
						echo '<p><button class="view-more-button heading-text">' . esc_attr__( 'View More', 'lokerpro' ) . '</button></p>';
					}
					echo '</div>';
				}

	} else {
		get_template_part( 'template-parts/content', 'none' );
	}
	?>

	</main><!-- #main -->
	</div>
</div><!-- #primary -->

<?php
get_sidebar( 'blogs' );

get_footer();
