<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Lokerpro
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?> <?php echo lokerpro_itemtype_schema( 'CreativeWork' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>

	<div class="pjs-box-content pjs-single">

		<header class="entry-header clearfix">
			<div class="title-wrap-blog">
				<?php the_title( '<h1 class="entry-title" ' . lokerpro_itemprop_schema( 'headline' ) . '>', '</h1>' ); ?>
				<?php
					pjs_posted_on();
				?>
				<div class="pjs-button-download">
					<?php do_action( 'lokerpro_add_share_the_content' ); ?>
				</div>
			</div>
		</header><!-- .entry-header -->

		<div class="entry-content entry-content-single" <?php echo lokerpro_itemprop_schema( 'text' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>
			<?php
				the_content();
			?>

		</div><!-- .entry-content -->

	</div><!-- .pjs-box-content -->

</article><!-- #post-## -->
