<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Lokerpro
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Custom field via core.
$downloads = get_post_meta( $post->ID, 'lokerpro_dlbutton_item', true );

if ( is_active_sidebar( 'download-1' ) && is_active_sidebar( 'download-2' ) ) {
	$class = 'col-md-4';
} elseif ( is_active_sidebar( 'download-1' ) || is_active_sidebar( 'download-2' ) ) {
	$class = 'col-md-6';
} else {
	$class = 'col-md-12';
}
$linkvar = ( get_query_var( 'link' ) ) ? get_query_var( 'link' ) : false;
?>

<div id="post-download">

	<div class="pjs-box-content pjs-single">

		<div class="entry-content entry-content-single">
			<div class="text-download">
				<div class="download-title">
					<?php
						echo '<h1>' . esc_html__( 'Apply to', 'lokerpro' ) . ' <a href="' . esc_url( get_permalink() ) . '" title="' . esc_html( get_the_title() ) . '">' . esc_html( get_the_title() ) . '</a>.</h1>';
					?>
				</div>
			</div>
			<?php

			if ( ! empty( $downloads ) ) {

				echo '<div class="row">';
				if ( $linkvar ) {
					echo '<div id="download" class="pjs-download-wrap clearfix ' . esc_html( $class ) . '">';
						echo '<h3 class="widget-title title-synopsis">' . esc_html__( 'Start Apply...', 'lokerpro' ) . '</h3>';
						echo '<p>' . esc_html__( 'Start Apply Job Vacancies at', 'lokerpro' ) . ' <a href="' . esc_url( get_permalink() ) . '" title="' . esc_html( get_the_title() ) . '">' . esc_html( get_the_title() ) . '</a> ' . esc_html__( 'will start in', 'lokerpro' ) . ' <label id="lblTime" style="font-weight:bold;"></label> ' . esc_html__( 'seconds', 'lokerpro' ) . '.</p>';
						echo '<p>' . esc_html__( 'The page will open automatically. If not, please click', 'lokerpro' );
						echo ' <a href="#" onclick="location.href=\'';
					// key as index (1,2,3 etc).
					foreach ( $downloads as $key => $download ) {
						if ( ! empty( $download['lokerpro_dlbutton_item_url'] ) && ( $linkvar == ( (int) $key + 1 ) ) ) {
							echo $download['lokerpro_dlbutton_item_url'];
						}
					}

						echo '\';" rel="nofollow" title="' . esc_html__( 'Link Apply', 'lokerpro' ) . ' ' . esc_html( get_the_title() ) . '">' . esc_html__( 'here', 'lokerpro' ) . '</a>.</p>';
					echo '</div>';
				} else {
					echo '<div id="download" class="pjs-download-wrap clearfix ' . esc_html( $class ) . '">';
						echo '<h3 class="widget-title title-synopsis">' . esc_html__( 'Link Apply', 'lokerpro' ) . '</h3>';
						echo '<ul class="pjs-download-list clearfix wp-dark-mode-ignore">';
					foreach ( $downloads as $key => $download ) {
						if ( ! empty( $download['lokerpro_dlbutton_item_url'] ) ) {
							$safelink = get_theme_mod( 'pjs_active-safelink-content', 0 );
							if($safelink != 0) {
							echo '<li><a href="' . esc_url( add_query_arg( 'link', ( (int) $key + 1 ) ) ) . '" class="button" rel="nofollow" target="_blank" title="' . esc_html__( 'Link Apply ', 'lokerpro' ) . ( (int) $key + 1 ) . '"> ';
							} else {
							echo '<li><a href="' . $download['lokerpro_dlbutton_item_url'] . '" class="button" rel="nofollow" target="_blank" title="' . esc_html__( 'Link Apply ', 'lokerpro' ) . ( (int) $key + 1 ) . '"> ';
							}
							if ( ! empty( $download['lokerpro_dlbutton_item_title'] ) ) {
								echo esc_html( $download['lokerpro_dlbutton_item_title'] );
							} else {
								echo esc_html__( 'Link Apply ', 'lokerpro' ) . ( (int) $key + 1 );
							}
							echo '</a></li>';
						}
					}
					echo '</ul>';
					echo '</div>';
				}
				if ( is_active_sidebar( 'download-1' ) ) {
					echo '<aside id="secondary" class="widget-area ' . esc_html( $class ) . '" role="complementary" ' . lokerpro_itemtype_schema( 'WPSideBar' ) . '>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						dynamic_sidebar( 'download-1' );
					echo '</aside>';
				}
				if ( is_active_sidebar( 'download-2' ) ) {
					echo '<aside id="secondary" class="widget-area ' . esc_html( $class ) . '" role="complementary" ' . lokerpro_itemtype_schema( 'WPSideBar' ) . '>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						dynamic_sidebar( 'download-2' );
					echo '</aside>';
				}
				echo '</div>';

			}


			if ( is_active_sidebar( 'download-3' ) ) {
				dynamic_sidebar( 'download-3' );
			}

			?>
			<?php do_action( 'lokerpro_core_related_post' ); ?>
		</div><!-- .entry-content -->

	</div><!-- .pjs-box-content -->

</div><!-- #post-## -->

<?php
if( $linkvar ) {
	echo '<script type="text/javascript">';
	foreach ( $downloads as $key => $download ) {
		if ( ! empty( $download['lokerpro_dlbutton_item_url'] ) && ( $linkvar == ( (int) $key + 1 ) ) ) {
			echo 'var url = "' . $download['lokerpro_dlbutton_item_url'] . '";';
		}
	}
		$timersafelink = get_theme_mod('pjs_timer-safelink', 5);
		echo 'var seconds = "'.$timersafelink.'";';

		echo 'function DelayRedirect(){';
			echo 'if ( seconds <= 0 ) {';
				echo 'window.location = url;';
			echo '} else {';
				echo 'seconds--;';
				echo 'document.getElementById("lblTime").innerHTML = seconds;';
				echo 'setTimeout("DelayRedirect()", 1000);';
			echo '}';
		echo '}';
		echo 'window.onload = function () {';
			echo 'DelayRedirect();';
		echo '}';
	echo '</script>';
}


function lokerpro_is_active2() {
  if ( is_admin() ) return;

  if (Lokerpro_License::instance()->status != 200) {
    wp_die( __( 'Please activate theme first!', 'lokerpro' ) );
  }
}
add_action( 'wp', 'lokerpro_is_active2' );