<?php
/**
 * Template part for displaying posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Lokerpro
 */

/* Exit if accessed directly */
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

// Disable thumbnail options via customizer.
$thumbnail = get_theme_mod( 'pjs_active-singlethumb', 0 );

$hasthumbnail = '';
if ( has_post_thumbnail() ) {
	$hasthumbnail = ' has-post-thumbnail';
}
$classes = '';
if ( 0 === $thumbnail ) {
	$classes = 'single-thumb hentry';
} else {
	$classes = 'no-single-thumb hentry';
}

?>

<article id="post-<?php the_ID(); ?>" class="<?php echo esc_html( $classes ); ?><?php echo esc_html( $hasthumbnail ); ?>" <?php echo lokerpro_itemtype_schema( 'JobPosting' ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>>

	<div class="pjs-box-content pjs-single">

		<header class="entry-header clearfix">
			<?php
			if ( 0 === $thumbnail ) :
				if ( has_post_thumbnail() ) {
					?>
					<figure class="pull-left">
						<?php the_post_thumbnail( 'medium' ); ?>
					</figure>
					<?php
				}
			endif;
			?>
			<div class="title-wrap">
				<?php the_title( '<h1 class="entry-title" ' . lokerpro_itemprop_schema( 'title' ) . '>', '</h1>' ); ?>
				<?php
					$amount = get_post_meta( $post->ID, 'LOKERPRO_Amount', true );
					$post_views = pvc_get_post_views( absint( get_the_ID() ) );
					$opsi11 = get_theme_mod( 'pjs_active-totalopeningjob', 0 );
					$opsi12 = get_theme_mod( 'pjs_active-viewedby', 0 );
					
					echo '<div class="entry-meta">';
					if ( ! empty( $amount ) && 0 === $opsi11 ) {
						echo esc_html__( 'Total Job Opening: ', 'lokerpro' );
						echo '<span itemprop="totalJobOpenings">' . esc_html( $amount ) . '</span>';
					}
					if ( ! empty( $amount ) && 0 === $opsi11 && 0 === $opsi12 ) { echo esc_html__( ' | ', 'lokerpro' ); }
					if ( 0 === $opsi12 ) {
						echo esc_html__( 'Viewed by ', 'lokerpro' ); 
						do_action( 'lokerpro_view_number_format' );
						echo esc_html__( ' people', 'lokerpro' ); 
					}
					echo '</div>';
					
				?>
				<div class="pjs-button-download wp-dark-mode-ignore">
					<?php
					// Custom field via core.
					$downloads = get_post_meta( $post->ID, 'lokerpro_dlbutton_item', true );
					$topapply = get_theme_mod( 'pjs_active-topapply', 0 );
					if ( 0 === $topapply ) {
					if ( ! empty( $downloads ) ) {
						?>
						<a href="<?php echo esc_url( get_permalink() . 'apply/' ); ?>" class="button in-single-download" title="<?php esc_attr_e( 'Apply Here ', 'lokerpro' ) . '' . the_title(); ?>"><?php esc_attr_e( 'Klik Disini', 'lokerpro' ); ?>
						<?php
						$filesize = get_post_meta( $post->ID, 'LOKERPRO_Filesize', true );
						if ( ! empty( $filesize ) ) {
							echo '<span class="download-filesize">(<span itemprop="fileSize">' . esc_attr( $filesize ) . '</span>)</span>';
						}
						?>
						</a>
					<?php } } ?>
					<?php do_action( 'lokerpro_add_share_the_content' ); ?>
				</div>
			</div>
		</header><!-- .entry-header -->
		<div class="entry-content entry-content-single">
			<div class="row">
				<div id="specs" class="col-md-3">
				<?php
					$opsi1 = get_theme_mod( 'pjs_active-postedby', 0 );
					$opsi2 = get_theme_mod( 'pjs_active-publisheddate', 0 );
					$opsi3 = get_theme_mod( 'pjs_active-category', 0 );
					$opsi4 = get_theme_mod( 'pjs_active-joblocation', 0 );
					$opsi5 = get_theme_mod( 'pjs_active-employmenttype', 0 );
					$opsi6 = get_theme_mod( 'pjs_active-educationrequirements', 0 );
					$opsi7 = get_theme_mod( 'pjs_active-experiencerequirements', 0 );
					$opsi8 = get_theme_mod( 'pjs_active-imagegallery', 0 );
					$opsi9 = get_theme_mod( 'pjs_active-closingdate', 0 );
					$opsi10 = get_theme_mod( 'pjs_active-tagpost', 0 );
					if (0 === $opsi1 || 0 === $opsi2 || 0 === $opsi3 || 0 === $opsi4 || 0 === $opsi5 || 0 === $opsi6 || 0 === $opsi7 ) {
					echo '<div class="pjs-list-specs">';
					if (0 === $opsi1){
					$posted_by = sprintf(
						/* translators: used between list items, there is a space after the comma */
						'%s',
						'<span class="entry-author vcard" ' . lokerpro_itemprop_schema( 'hiringOrganization' ) . ' ' . lokerpro_itemtype_schema( 'Organization' ) . '><a class="url fn n" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '" title="' . __( 'Permalink to: ', 'lokerpro' ) . esc_html( get_the_author() ) . '" ' . lokerpro_itemprop_schema( 'url' ) . '><span ' . lokerpro_itemprop_schema( 'name' ) . '>' . esc_html( get_the_author() ) . '</span></a></span>'
					); };
					echo '<table class="table-pjs"><tbody>'; if (0 === $opsi1){ echo '<tr><th>' . esc_html__( 'Diposting oleh', 'lokerpro' ) . '</th><td>:</td><td>' . $posted_by; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					echo '</td></tr>'; };
					if (0 === $opsi2){
					$time_string = '<time class="entry-date published updated" ' . lokerpro_itemprop_schema( 'datePosted' ) . ' datetime="%1$s">%2$s</time>';
					if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
						$time_string = '<time class="entry-date published" ' . lokerpro_itemprop_schema( 'datePosted' ) . ' datetime="%1$s">%2$s</time><time class="updated" datetime="%3$s">%4$s</time>';
					}
					$time_string = sprintf(
						$time_string,
						esc_attr( get_the_date( 'c' ) ),
						esc_html( get_the_date() ),
						esc_attr( get_the_modified_date( 'c' ) ),
						esc_html( get_the_modified_date() )
					);

					$posted_on = '<tr><th>' . esc_html__( 'Tanggal Publikasi', 'lokerpro' ) . '</th><td>:</td><td>' . $time_string;
					echo $posted_on; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					echo '</td></tr>'; };
					if (0 === $opsi3){
					/* translators: used between list items, there is a space after the comma */
					$categories_list = get_the_category_list( esc_html__( ', ', 'lokerpro' ) );
					if ( $categories_list ) {
						echo '<tr><th>' . esc_html__( 'Category', 'lokerpro' ) . '</th><td>:</td><td>' . $categories_list; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						echo '<span class="screen-reader-text" itemprop="occupationalCategory">' . wp_strip_all_tags( $categories_list ) . '</span>'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
					echo '</td></tr>';
					}; };
					if (0 === $opsi4){
					$system = get_post_meta( $post->ID, 'LOKERPRO_System', true );
					if ( ! empty( $system ) ) {
							echo '<tr><th>' . esc_html__( 'Lokasi', 'lokerpro' ) . '</th><td>:</td><td>';
							echo '<span ' . lokerpro_itemprop_schema( 'jobLocation' ) . ' ' . lokerpro_itemtype_schema( 'Place' ) . '><span ' . lokerpro_itemprop_schema( 'address' ) . '>' . esc_html( $system ) . '</span></span>';
					echo '</td></tr>';
					}; };
					if (0 === $opsi5){
					$license = get_post_meta( $post->ID, 'LOKERPRO_License', true );
					if ( ! empty( $license ) ) {
							echo '<tr><th>' . esc_html__( 'Jenis Pekerjaan', 'lokerpro' ) . '</th><td>:</td><td>';
							echo '<span itemprop="employmentType">' . esc_html( $license ) . '</span>';
					echo '</td></tr>';
					}; };
					if (0 === $opsi6){
					$dev = get_post_meta( $post->ID, 'LOKERPRO_Developer', true );
					if ( ! empty( $dev ) ) {
							echo '<tr><th>' . esc_html__( 'Pendidikan', 'lokerpro' ) . '</th><td>:</td><td>';
							echo '<span itemprop="educationRequirements">' . esc_html( $dev ) . '</span>';
					echo '</td></tr>';
					}; };
					if (0 === $opsi7){
					$dev = get_post_meta( $post->ID, 'LOKERPRO_Pengalaman', true );
					if ( ! empty( $dev ) ) {
							echo '<tr><th>' . esc_html__( 'Pengalaman', 'lokerpro' ) . '</th><td>:</td><td>';
							echo '<span itemprop="experienceRequirements">' . esc_html( $dev ) . '</span>';
					echo '</td></tr>';
					}; };
					
//					if ( class_exists( 'Post_Views_Counter' ) ) {
//						$number = pvc_get_post_views( $post->ID );
//  					echo '<tr><th>' . esc_html__( 'Dilihat', 'lokerpro' ) . '</th><td>:</td><td>';
//    				echo absint( $number );
//		    		echo '</td></tr>';
//					} elseif ( function_exists( 'the_views' ) ) {
//							echo '<tr><th>' . esc_html__( 'Dilihat: ', 'lokerpro' ) . '</span><br/>';
//							the_views();
//					echo '</td></tr>';
//					}
          echo '</tbody></table></div>'; };
				?>
				</div>
				<div id="description" class="col-md-9">
					<?php
					$gallery = get_post_meta( $post->ID, 'LOKERPRO_Gallery', true );
					$closingdate = get_post_meta( $post->ID, 'LOKERPRO_ClosingDate', true );
					$textregister = get_theme_mod( 'pjs_text_register' );
					if (0 === $opsi8){
					if ( ! empty( $gallery ) ) {
						echo do_shortcode( $gallery );
					}; };
					if ( '' !== $post->post_content ) { 
						echo '<span ' . lokerpro_itemprop_schema( 'description' ) . '>'; the_content(); echo '</span>';
					} else {
						echo esc_html__( 'No description', 'lokerpro' );
					}
					$botapply = get_theme_mod( 'pjs_active-botapply', 0 );
					if ( 0 === $botapply ) {
					if ( ! empty( $downloads ) ) {
						?><ul class="pjs-list-specs bawah"><li><center><b><?php if ( empty( $textregister ) ) {echo esc_attr_e( 'Kirim Lamaran Kerja:', 'lokerpro' ); } else { echo $textregister; } ?></b><br><br>
						<a href="<?php echo esc_url( get_permalink() . 'apply/' ); ?>" class="button in-single-download" title="<?php esc_attr_e( 'Apply Here ', 'lokerpro' ) . '' . the_title(); ?>"><?php esc_attr_e( '👉 Klik Disini 👈', 'lokerpro' ); 
					?></a></center></li></ul><?php }; }; if (0 === $opsi9){ if ( ! empty( $closingdate ) ) { ?>
					<ul class="pjs-list-specs bawah"><li><span class="list-title"><?php esc_attr_e( '📅 Ditutup Tanggal', 'lokerpro' ); 
					?></span>: <?php echo (new DateTime($closingdate)) ->format('d M Y'); ?></li></ul>
<?php }; }; $additionaltext = get_theme_mod( 'pjs_infojob'); ?>
<?php if ( ! empty( $additionaltext ) ) { echo '<div class="disclaimer_box">
<div class="content"><div style="text-align: justify;">' . $additionaltext . '</div></div>
</div>'; } ?>
					<?php 
					/* translators: used between list items, there is a space after the comma */
/*					$tags_list = get_the_tag_list( '', esc_html__( ', ', 'lokerpro' ) ); */
					if (0 === $opsi10){
					$tags_list = get_the_tag_list( '', esc_html__( '  ', 'lokerpro' ) );
					if ( $tags_list ) {
						echo '<div class="tagcloud">';
						echo '<div class="tagtitle">' . esc_html__( 'Tagged: ', 'lokerpro' ) . '</div>' . $tags_list; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
						echo '</div>';
					};
					};
//					if ( function_exists( 'the_ratings' ) ) {
//						the_ratings();
//					} elseif ( shortcode_exists( 'ratemypost-result' ) ) {
//						echo do_shortcode( '[ratemypost]' );
//					}
					?>
				</div>
			</div>
			<?php do_action( 'lokerpro_related_post_display' ); ?>
			<?php do_action( 'lokerpro_banner_after_relpost' ); ?>

		</div><!-- .entry-content -->

	</div><!-- .pjs-box-content -->

	<?php do_action( 'lokerpro_author_box' ); ?>

</article><!-- #post-## -->
